/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.CenteredArea;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.MarkedAreaType;
import de.z0rdak.yawp.util.AreaUtil;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.apache.commons.lang3.NotImplementedException;

public class VerticalCylinderArea
extends CenteredArea {
    private final BlockPos centerTopPos;
    private final int distance;
    private final int radius;

    public VerticalCylinderArea(BlockPos centerBottomPos, BlockPos scopePos) {
        super(centerBottomPos, AreaType.CYLINDER);
        this.centerTopPos = new BlockPos(centerBottomPos.m_123341_(), scopePos.m_123342_(), centerBottomPos.m_123343_());
        this.radius = AreaUtil.distanceManhattan(centerBottomPos, new BlockPos(scopePos.m_123341_(), centerBottomPos.m_123342_(), scopePos.m_123343_()));
        this.distance = AreaUtil.distanceManhattan(centerBottomPos, this.centerTopPos);
    }

    public VerticalCylinderArea(BlockPos centerBottomPos, int radius, int distance) {
        super(centerBottomPos, AreaType.CYLINDER);
        this.centerTopPos = centerBottomPos.m_7918_(0, distance, 0);
        this.radius = radius;
        this.distance = distance;
    }

    @Override
    public Vec3i getCenter() {
        return new Vec3i(this.center.m_123341_(), this.center.m_123342_(), this.center.m_123343_());
    }

    @Override
    public boolean contains(BlockPos pos) {
        BlockPos dist = this.centerTopPos.m_121996_((Vec3i)this.center);
        boolean b1 = this.multiply(pos.m_121996_((Vec3i)this.center), dist).compareTo((Vec3i)BlockPos.f_121853_) >= 0;
        boolean b2 = this.multiply(pos.m_121996_((Vec3i)this.centerTopPos), dist).compareTo((Vec3i)BlockPos.f_121853_) <= 0;
        boolean isBetweenPlanes = b1 && b2;
        BlockPos crossProduct = pos.m_121996_((Vec3i)this.center).m_7724_((Vec3i)dist);
        double distance = AreaUtil.length(crossProduct) / (double)AreaUtil.distanceManhattan(this.centerTopPos, this.center);
        boolean isInsideSurface = distance <= (double)this.radius;
        return isBetweenPlanes && isInsideSurface;
    }

    @Override
    public Set<BlockPos> getHull() {
        throw new NotImplementedException("CylinderArea.getHull() not implemented yet");
    }

    @Override
    public Set<BlockPos> getFrame() {
        return Set.of();
    }

    @Override
    public Set<BlockPos> getMinimalOutline() {
        return Set.of();
    }

    public int getDistance() {
        return this.distance;
    }

    public int getRadius() {
        return this.radius;
    }

    public BlockPos multiply(BlockPos p1, BlockPos p2) {
        return new BlockPos(p1.m_123341_() * p2.m_123341_(), p1.m_123342_() * p2.m_123342_(), p1.m_123343_() * p2.m_123343_());
    }

    @Override
    public boolean containsOther(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public boolean intersects(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public MarkedAreaType<?> getType() {
        return null;
    }

    public String toString() {
        return "Cylinder " + AreaUtil.blockPosStr(this.center) + " with radius " + this.radius + " and height " + this.distance + ".";
    }
}

