/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.region;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.core.flag.Flag;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlags;
import de.z0rdak.yawp.core.group.PlayerContainer;
import de.z0rdak.yawp.core.region.GlobalRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.ProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public final class DimensionalRegion
extends ProtectedRegion {
    public static final Codec<DimensionalRegion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(ProtectedRegion::getName), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("dimension").forGetter(ProtectedRegion::getDim), (App)Codec.STRING.fieldOf("parentName").forGetter(ProtectedRegion::getParentName), (App)Codec.STRING.fieldOf("type").forGetter(r -> r.getRegionType().type), (App)Codec.unboundedMap((Codec)Codec.STRING, Flag.CODEC).fieldOf("flags").forGetter(r -> r.getFlags().getFlagMap()), (App)Codec.BOOL.fieldOf("isActive").forGetter(ProtectedRegion::isActive), (App)Codec.BOOL.fieldOf("isMuted").forGetter(ProtectedRegion::isMuted), (App)Codec.unboundedMap((Codec)Codec.STRING, PlayerContainer.CODEC).fieldOf("groups").forGetter(ProtectedRegion::getGroups), (App)Codec.list((Codec)Codec.STRING).fieldOf("childrenNames").forGetter(r -> new ArrayList<String>(r.getChildrenNames()))).apply((Applicative)instance, (name, dim, parentName, regionType, flags, isActive, isMuted, groups, childrenNames) -> new DimensionalRegion((ResourceKey<Level>)dim, new RegionFlags((Map<String, IFlag>)flags), (boolean)isActive, (boolean)isMuted, (Map<String, PlayerContainer>)groups, (List<String>)childrenNames)));

    public DimensionalRegion(ResourceKey<Level> dimensionKey, IProtectedRegion parent) {
        super(dimensionKey.m_135782_().toString(), dimensionKey, RegionType.DIMENSION);
        this.dimension = dimensionKey;
        if (!(parent instanceof GlobalRegion)) {
            throw new IllegalArgumentException("Illegal parent region for dimensional region");
        }
        this.setParent(parent);
    }

    private DimensionalRegion(ResourceKey<Level> dim, RegionFlags flags, boolean isActive, boolean isMuted, Map<String, PlayerContainer> groups, List<String> childrenNames) {
        super(dim.m_135782_().toString(), dim, RegionType.DIMENSION);
        this.dimension = dim;
        GlobalRegion globalRegion = RegionManager.get().getGlobalRegion();
        this.setParent(globalRegion);
        this.setFlags(flags);
        this.setIsActive(isActive);
        this.setIsMuted(isMuted);
        this.setGroups(groups);
        this.setChildrenNames(childrenNames);
    }

    @Override
    protected boolean setParent(IProtectedRegion parent) {
        if (parent.getRegionType() == RegionType.GLOBAL) {
            return super.setParent(parent);
        }
        return false;
    }

    @Override
    public boolean addChild(IProtectedRegion child) {
        if (child.getRegionType() == RegionType.LOCAL && child.getParent() == null) {
            String parentName = child.getParentName();
            if (parentName != null && !parentName.equals(this.getName())) {
                super.addChild(child);
                ((ProtectedRegion)child).parentName = parentName;
                return true;
            }
            return super.addChild(child);
        }
        if (child.getRegionType() == RegionType.LOCAL && child.getParent().getRegionType() == RegionType.DIMENSION) {
            return super.addChild(child);
        }
        if (child.getRegionType() == RegionType.LOCAL && !child.getParent().hasChild(child)) {
            return super.addChild(child);
        }
        return false;
    }

    @Override
    public String getName() {
        return this.dimension.m_135782_().toString();
    }
}

