/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.region;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.core.flag.Flag;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlags;
import de.z0rdak.yawp.core.group.PlayerContainer;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.ProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class GlobalRegion
extends ProtectedRegion {
    public static final Codec<GlobalRegion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(ProtectedRegion::getName), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("dimension").forGetter(ProtectedRegion::getDim), (App)Codec.STRING.fieldOf("parentName").forGetter(ProtectedRegion::getParentName), (App)Codec.STRING.fieldOf("type").forGetter(r -> r.getRegionType().type), (App)Codec.unboundedMap((Codec)Codec.STRING, Flag.CODEC).fieldOf("flags").forGetter(r -> r.getFlags().getFlagMap()), (App)Codec.BOOL.fieldOf("isActive").forGetter(ProtectedRegion::isActive), (App)Codec.BOOL.fieldOf("isMuted").forGetter(ProtectedRegion::isMuted), (App)Codec.unboundedMap((Codec)Codec.STRING, PlayerContainer.CODEC).fieldOf("groups").forGetter(ProtectedRegion::getGroups), (App)Codec.list((Codec)Codec.STRING).fieldOf("childrenNames").forGetter(r -> new ArrayList<String>(r.getChildrenNames()))).apply((Applicative)instance, (name, dim, parentName, regionType, flags, isActive, isMuted, groups, childrenNames) -> new GlobalRegion(new RegionFlags((Map<String, IFlag>)flags), (boolean)isActive, (boolean)isMuted, (Map<String, PlayerContainer>)groups, (List<String>)childrenNames)));
    public static final ResourceLocation GLOBAL = new ResourceLocation("yawp", "global");
    public static final ResourceKey<Level> GLOBAL_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)GLOBAL);

    public GlobalRegion() {
        this(GLOBAL.toString(), RegionType.GLOBAL);
        this.setParent(this);
    }

    private GlobalRegion(RegionFlags flags, boolean isActive, boolean isMuted, Map<String, PlayerContainer> groups, List<String> childrenNames) {
        this(GLOBAL.toString(), RegionType.GLOBAL);
        this.setParent(this);
        this.setFlags(flags);
        this.setIsActive(isActive);
        this.setIsMuted(isMuted);
        this.setGroups(groups);
        this.setChildrenNames(childrenNames);
    }

    protected GlobalRegion(String name, RegionType type) {
        super(name, GLOBAL_DIMENSION, type);
        super.setParent(this);
    }

    @Override
    public Map<String, IProtectedRegion> getChildren() {
        Map<String, IProtectedRegion> childrenWithoutGlobal = super.getChildren().entrySet().stream().filter(e -> ((IProtectedRegion)e.getValue()).getRegionType() != RegionType.GLOBAL).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return Collections.unmodifiableMap(childrenWithoutGlobal);
    }

    @Override
    public Set<String> getChildrenNames() {
        Set childrenWithoutGlobal = super.getChildren().values().stream().filter(iProtectedRegion -> iProtectedRegion.getRegionType() != RegionType.GLOBAL).map(IProtectedRegion::getName).collect(Collectors.toSet());
        return Collections.unmodifiableSet(childrenWithoutGlobal);
    }

    @Override
    protected boolean setParent(IProtectedRegion parent) {
        if (parent.getRegionType() == RegionType.GLOBAL) {
            return super.setParent(parent);
        }
        return false;
    }

    @Override
    public boolean addChild(IProtectedRegion child) {
        if (child.getRegionType() == RegionType.DIMENSION) {
            return super.addChild(child);
        }
        return false;
    }
}

