/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.handler;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.handler.HandlerUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;

public class YawpEventHandler {
    public static void removeInvolvedEntities(CommandSourceStack src, IProtectedRegion region, RegionFlag flag) {
        ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)region.getDim().m_135782_());
        MinecraftServer server = src.m_81377_();
        Predicate<? super Entity> entityFilter = YawpEventHandler.getEntityFilterForFlag(flag);
        switch (region.getRegionType()) {
            case GLOBAL: {
                server.m_129785_().forEach(world -> {
                    List<Entity> entitiesToRemove = YawpEventHandler.getEntitiesToRemove(world, entityFilter, flag);
                    entitiesToRemove.forEach(e -> e.m_142467_(Entity.RemovalReason.DISCARDED));
                });
                break;
            }
            case DIMENSION: {
                ServerLevel regionWorld = server.m_129880_(dimKey);
                if (regionWorld == null) break;
                List<Entity> entitiesToRemove = YawpEventHandler.getEntitiesToRemove(regionWorld, entityFilter, flag);
                entitiesToRemove.forEach(e -> e.m_142467_(Entity.RemovalReason.DISCARDED));
                break;
            }
            case LOCAL: {
                ServerLevel regionWorld = server.m_129880_(dimKey);
                if (regionWorld == null) break;
                List<Entity> entitiesToRemove = YawpEventHandler.getEntitiesToRemove(regionWorld, (IMarkableRegion)region, entityFilter);
                entitiesToRemove.forEach(e -> e.m_142467_(Entity.RemovalReason.DISCARDED));
            }
        }
    }

    private static Predicate<? super Entity> getEntityFilterForFlag(RegionFlag flag) {
        switch (flag) {
            case SPAWNING_ALL: {
                return e -> e instanceof Mob;
            }
            case SPAWNING_MONSTER: {
                return HandlerUtil::isMonster;
            }
            case SPAWNING_ANIMAL: {
                return HandlerUtil::isAnimal;
            }
            case SPAWNING_GOLEM: {
                return e -> e instanceof SnowGolem || e instanceof IronGolem;
            }
            case SPAWNING_TRADER: {
                return e -> e instanceof WanderingTrader;
            }
            case SPAWNING_SLIME: {
                return e -> e instanceof Slime;
            }
            case SPAWNING_VILLAGER: {
                return HandlerUtil::isVillager;
            }
            case SPAWNING_XP: {
                return e -> e instanceof ExperienceOrb;
            }
        }
        return e -> false;
    }

    private static List<Entity> getEntitiesToRemove(ServerLevel level, IMarkableRegion region, Predicate<? super Entity> entityFilter) {
        List entities = level.m_143280_(EntityTypeTest.m_156916_(Entity.class), entityFilter);
        return entities.stream().filter(e -> region.getArea().containsOther(new CuboidArea(e.m_20183_(), e.m_20183_()))).filter(YawpEventHandler::isNotPersistent).collect(Collectors.toList());
    }

    private static List<Entity> getEntitiesToRemove(ServerLevel level, Predicate<? super Entity> entityFilter, RegionFlag flag) {
        List entities = level.m_143280_(EntityTypeTest.m_156916_(Entity.class), entityFilter);
        return entities.stream().filter(e -> !YawpEventHandler.isProtectedByRegion(level, flag, e)).filter(YawpEventHandler::isNotPersistent).collect(Collectors.toList());
    }

    private static boolean isNotPersistent(Entity e) {
        return !YawpEventHandler.hasEnabledPersistenceFlag(e) && !e.m_8077_();
    }

    private static boolean hasEnabledPersistenceFlag(Entity e) {
        if (e instanceof Mob) {
            Mob mob = (Mob)e;
            return mob.m_21532_();
        }
        return false;
    }

    private static boolean isProtectedByRegion(ServerLevel level, RegionFlag flag, Entity e) {
        FlagCheckEvent checkEvent = new FlagCheckEvent(e.m_20183_(), flag, (ResourceKey<Level>)level.m_46472_());
        FlagState flagState = FlagEvaluator.processCheck(checkEvent);
        return flagState == FlagState.ALLOWED;
    }
}

