/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.handler.flags;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.api.events.region.FlagCheckResult;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.handler.flags.ForgeHandlerUtil;
import de.z0rdak.yawp.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

@Mod.EventBusSubscriber(modid="yawp", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class PlayerFlagHandler {
    private PlayerFlagHandler() {
    }

    @SubscribeEvent
    public static void onLooseArrow(ArrowLooseEvent event) {
        if (!HandlerUtil.isServerSide(event.getLevel())) {
            return;
        }
        if (event.getEntity() != null) {
            Player shooter = event.getEntity();
            FlagCheckEvent checkEvent = new FlagCheckEvent(shooter.m_20183_(), RegionFlag.FIRE_BOW, HandlerUtil.getDimKey(event.getLevel()), shooter);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                event.setCharge(0);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onProjectileHitPlayer(ProjectileImpactEvent event) {
        EntityHitResult entityHitRes;
        Entity hitEntity;
        HitResult hitResult;
        boolean wasHit;
        boolean isTypeOf;
        Projectile projectile = event.getProjectile();
        if (!HandlerUtil.isServerSide((Entity)projectile)) {
            return;
        }
        Entity shooter = projectile.m_19749_();
        boolean bl = isTypeOf = projectile instanceof FireworkRocketEntity || projectile instanceof AbstractArrow || projectile instanceof Snowball || projectile instanceof ThrownEgg || projectile instanceof ThrownEnderpearl;
        if (!isTypeOf) {
            return;
        }
        boolean wasShotByPlayer = shooter instanceof Player;
        boolean bl2 = wasHit = event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY;
        if (wasShotByPlayer && wasHit && (hitResult = event.getRayTraceResult()) instanceof EntityHitResult && (hitEntity = (entityHitRes = (EntityHitResult)hitResult).m_82443_()) instanceof Player) {
            Player hitPlayer = (Player)hitEntity;
            FlagCheckEvent checkEvent = new FlagCheckEvent(hitPlayer.m_20183_(), RegionFlag.NO_PVP, HandlerUtil.getDimKey((Entity)hitPlayer), (Player)shooter);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onElytraFlying(TickEvent.PlayerTickEvent event) {
        if (HandlerUtil.isServerSide((Entity)event.player) && event.phase == TickEvent.Phase.END) {
            ResourceKey<Level> dim = HandlerUtil.getDimKey((Entity)event.player);
            if (event.player.m_21255_()) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(event.player.m_20183_(), RegionFlag.NO_FLIGHT, dim, event.player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> event.player.m_36321_());
            }
        }
    }

    @SubscribeEvent
    public static void onAttackPlayer(AttackEntityEvent event) {
        if (ForgeHandlerUtil.notServerSideOrPlayerNull((PlayerEvent)event)) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player target = (Player)entity;
            Player attacker = event.getEntity();
            ResourceKey<Level> dim = HandlerUtil.getDimKey((Entity)attacker);
            FlagCheckEvent checkEvent = new FlagCheckEvent(target.m_20183_(), RegionFlag.MELEE_PLAYERS, dim, attacker);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        if (ForgeHandlerUtil.notServerSideOrPlayerNull((PlayerEvent)event)) {
            return;
        }
        Player player = event.getEntity();
        Entity eventEntity = event.getTarget();
        ResourceKey<Level> dim = HandlerUtil.getDimKey((Entity)event.getEntity());
        BlockPos entityPos = eventEntity.m_20183_();
        FlagCheckEvent checkEvent = null;
        if (HandlerUtil.isAnimal(eventEntity) && Services.EVENT.post(checkEvent = new FlagCheckEvent(entityPos, RegionFlag.MELEE_ANIMALS, dim, player))) {
            return;
        }
        if (HandlerUtil.isMonster(eventEntity) && Services.EVENT.post(checkEvent = new FlagCheckEvent(entityPos, RegionFlag.MELEE_MONSTERS, dim, player))) {
            return;
        }
        if (event.getTarget() instanceof Villager && Services.EVENT.post(checkEvent = new FlagCheckEvent(entityPos, RegionFlag.MELEE_VILLAGERS, dim, player))) {
            return;
        }
        if (event.getTarget() instanceof WanderingTrader && Services.EVENT.post(checkEvent = new FlagCheckEvent(entityPos, RegionFlag.MELEE_WANDERING_TRADER, dim, player))) {
            return;
        }
        if (checkEvent != null) {
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onPickupItem(EntityItemPickupEvent event) {
        if (ForgeHandlerUtil.notServerSideOrPlayerNull((PlayerEvent)event)) {
            return;
        }
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getEntity().m_20183_(), RegionFlag.ITEM_PICKUP, HandlerUtil.getDimKey((Entity)event.getEntity()), event.getEntity());
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onBreedingAttempt(BabyEntitySpawnEvent event) {
        Player player = event.getCausedByPlayer();
        if (player == null) {
            return;
        }
        if (!player.m_20193_().f_46443_) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getParentB().m_20183_(), RegionFlag.ANIMAL_BREEDING, HandlerUtil.getDimKey((Entity)player), event.getCausedByPlayer());
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onAnimalTameAttempt(AnimalTameEvent event) {
        Player player = event.getTamer();
        if (player == null) {
            return;
        }
        if (!player.m_20193_().f_46443_) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getAnimal().m_20183_(), RegionFlag.ANIMAL_TAMING, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLevelChange(PlayerXpEvent.LevelChange event) {
        if (ForgeHandlerUtil.notServerSideOrPlayerNull((PlayerEvent)event)) {
            return;
        }
        Player player = event.getEntity();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getEntity().m_20183_(), RegionFlag.LEVEL_FREEZE, HandlerUtil.getDimKey((Entity)player), player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onPlayerXPChange(PlayerXpEvent.XpChange event) {
        if (ForgeHandlerUtil.notServerSideOrPlayerNull((PlayerEvent)event)) {
            return;
        }
        Player player = event.getEntity();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getEntity().m_20183_(), RegionFlag.XP_FREEZE, HandlerUtil.getDimKey((Entity)player), player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            event.setAmount(0);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onPlayerXpPickup(PlayerXpEvent.PickupXp event) {
        if (ForgeHandlerUtil.notServerSideOrPlayerNull((PlayerEvent)event)) {
            return;
        }
        Player player = event.getEntity();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getEntity().m_20183_(), RegionFlag.XP_PICKUP, HandlerUtil.getDimKey((Entity)player), player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            event.getOrb().m_142687_(Entity.RemovalReason.DISCARDED);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onPvpAction(LivingHurtEvent event) {
        if (ForgeHandlerUtil.isServerSide((EntityEvent)event)) {
            if (event.getSource() == null || event.getEntity() == null) {
                return;
            }
            Entity dmgSourceEntity = event.getSource().m_7640_();
            LivingEntity hurtEntity = event.getEntity();
            if (hurtEntity instanceof Player) {
                Player playerTarget = (Player)hurtEntity;
                if (dmgSourceEntity instanceof Player) {
                    Player playerSource = (Player)dmgSourceEntity;
                    FlagCheckEvent checkEvent = new FlagCheckEvent(playerTarget.m_20183_(), RegionFlag.NO_PVP, HandlerUtil.getDimKey((Entity)playerSource), playerSource);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, onDeny -> {
                        event.setCanceled(true);
                        event.setAmount(0.0f);
                        MessageSender.sendFlagMsg(onDeny);
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        LivingEntity hurtEntity;
        if (ForgeHandlerUtil.isServerSide((EntityEvent)event) && (hurtEntity = event.getEntity()) instanceof Player) {
            Player playerTarget = (Player)hurtEntity;
            FlagCheckEvent checkEvent = new FlagCheckEvent(playerTarget.m_20183_(), RegionFlag.INVINCIBLE, HandlerUtil.getDimKey((Entity)playerTarget), playerTarget);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                event.setAmount(0.0f);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onReceiveDmg(LivingDamageEvent event) {
        if (ForgeHandlerUtil.isServerSide((EntityEvent)event)) {
            if (event.getSource() == null || event.getEntity() == null) {
                return;
            }
            Entity dmgSourceEntity = event.getSource().m_7640_();
            if (dmgSourceEntity instanceof Player) {
                Player dmgSource = (Player)dmgSourceEntity;
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof Player) {
                    Player dmgTarget = (Player)livingEntity;
                    FlagCheckEvent checkEvent = new FlagCheckEvent(dmgTarget.m_20183_(), RegionFlag.MELEE_PLAYERS, HandlerUtil.getDimKey((Entity)dmgSource), dmgSource);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, onDeny -> {
                        event.setCanceled(true);
                        event.setAmount(0.0f);
                        MessageSender.sendFlagMsg(onDeny);
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerKnockback(LivingKnockBackEvent event) {
        LivingEntity livingEntity;
        if (ForgeHandlerUtil.isServerSide((EntityEvent)event) && (livingEntity = event.getEntity()) instanceof Player) {
            Player dmgTarget = (Player)livingEntity;
            FlagCheckEvent checkEvent = new FlagCheckEvent(dmgTarget.m_20183_(), RegionFlag.KNOCKBACK_PLAYERS, HandlerUtil.getDimKey((Entity)dmgTarget), dmgTarget);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                event.setStrength(0.0f);
                MessageSender.sendFlagMsg(onDeny);
            });
            checkEvent = new FlagCheckEvent(dmgTarget.m_20183_(), RegionFlag.INVINCIBLE, HandlerUtil.getDimKey((Entity)dmgTarget), dmgTarget);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                event.setStrength(0.0f);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        if (ForgeHandlerUtil.isServerSide((BlockEvent)event)) {
            if (event.getPlayer() == null) {
                return;
            }
            Player player = event.getPlayer();
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.BREAK_BLOCKS, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                HandlerUtil.updateBlockState((Level)event.getLevel(), event.getPos());
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        if (ForgeHandlerUtil.isServerSide((BlockEvent)event)) {
            Entity entity;
            if (event.getEntity() == null || !((entity = event.getEntity()) instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.PLACE_BLOCKS, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                HandlerUtil.updateBlockState((Level)event.getLevel(), event.getPos());
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityBreak(AttackEntityEvent event) {
        if (ForgeHandlerUtil.isServerSide((EntityEvent)event)) {
            if (event.getTarget() == null || event.getEntity() == null) {
                return;
            }
            Entity target = event.getTarget();
            Player player = event.getEntity();
            Set<String> entityTags = Services.FLAG_CONFIG.getCoveredBlockEntityTags();
            boolean isCoveredByTag = entityTags.stream().anyMatch(entityTag -> {
                ResourceLocation tagRl = ResourceLocation.parse((String)entityTag);
                return target.m_19880_().contains(tagRl.m_135815_());
            });
            Set<String> entities = Services.FLAG_CONFIG.getCoveredBlockEntities();
            boolean isBlockEntityCovered = entities.stream().anyMatch(entity -> {
                ResourceLocation entityRl = ResourceLocation.parse((String)entity);
                ResourceLocation targetRl = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_());
                return targetRl != null && targetRl.equals((Object)entityRl);
            });
            if (isBlockEntityCovered || isCoveredByTag) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(event.getTarget().m_20183_(), RegionFlag.BREAK_BLOCKS, HandlerUtil.getDimKey((Entity)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(onDeny);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onExplosionStarted(ExplosionEvent.Start event) {
        if (HandlerUtil.isServerSide(event.getLevel())) {
            if (event.getExplosion() == null) {
                return;
            }
            Explosion explosion = event.getExplosion();
            BlockPos explosionPos = new BlockPos((int)explosion.getPosition().f_82479_, (int)explosion.getPosition().f_82480_, (int)explosion.getPosition().f_82481_);
            ResourceKey dim = event.getLevel().m_46472_();
            if (explosion.m_252906_() == null) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(explosionPos, RegionFlag.IGNITE_EXPLOSIVES, (ResourceKey<Level>)dim);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> event.setCanceled(true));
            } else {
                LivingEntity livingEntity = explosion.m_252906_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    FlagCheckEvent checkEvent = new FlagCheckEvent(explosionPos, RegionFlag.IGNITE_EXPLOSIVES, (ResourceKey<Level>)dim, player);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, onDeny -> {
                        event.setCanceled(true);
                        MessageSender.sendFlagMsg(onDeny);
                    });
                }
                if (explosion.m_252906_() instanceof Monster) {
                    checkEvent = new FlagCheckEvent(explosionPos, RegionFlag.MOB_GRIEFING, (ResourceKey<Level>)dim);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, onDeny -> event.setCanceled(true));
                } else {
                    checkEvent = new FlagCheckEvent(explosionPos, RegionFlag.IGNITE_EXPLOSIVES, (ResourceKey<Level>)dim);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, onDeny -> event.setCanceled(true));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBonemealUse(BonemealEvent event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.USE_BONEMEAL, HandlerUtil.getDimKey((Entity)player), player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onPlayerUseEnderPearl(EntityTeleportEvent event) {
        if (ForgeHandlerUtil.isServerSide((EntityEvent)event) && event instanceof EntityTeleportEvent.EnderPearl) {
            EntityTeleportEvent.EnderPearl enderPearlEvent = (EntityTeleportEvent.EnderPearl)event;
            if (enderPearlEvent.getPlayer() == null) {
                return;
            }
            BlockPos target = new BlockPos((int)event.getTarget().f_82479_, (int)event.getTarget().f_82480_, (int)event.getTarget().f_82481_);
            ServerPlayer player = enderPearlEvent.getPlayer();
            FlagCheckEvent checkEvent = new FlagCheckEvent(target, RegionFlag.USE_ENDERPEARL_TO_REGION, HandlerUtil.getDimKey((Entity)player), (Player)player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
            if (flagState == FlagState.DENIED) {
                return;
            }
            target = new BlockPos((int)event.getTarget().f_82479_, (int)event.getTarget().f_82480_, (int)event.getTarget().f_82481_);
            checkEvent = new FlagCheckEvent(target, RegionFlag.USE_ENDERPEARL_FROM_REGION, HandlerUtil.getDimKey((Entity)player), (Player)player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
            player.m_150109_().m_6596_();
        }
    }

    @SubscribeEvent
    public static void onPlayerUseToolSecondary(BlockEvent.BlockToolModificationEvent event) {
        if (ForgeHandlerUtil.isServerSide((BlockEvent)event)) {
            ResourceKey<Level> dim;
            Player player = event.getPlayer();
            if (player == null) {
                return;
            }
            BlockPos target = event.getPos();
            FlagCheckEvent checkEvent = new FlagCheckEvent(target, RegionFlag.TOOL_SECONDARY_USE, dim = HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
            if (flagState == FlagState.DENIED) {
                return;
            }
            if (event.getToolAction().equals(ToolActions.AXE_STRIP) && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.AXE_STRIP, dim, player))) {
                return;
            }
            if (event.getToolAction().equals(ToolActions.HOE_TILL) && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.HOE_TILL, dim, player))) {
                return;
            }
            if (event.getToolAction().equals(ToolActions.SHOVEL_FLATTEN) && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.SHOVEL_PATH, dim, player))) {
                return;
            }
            if (checkEvent != null) {
                FlagEvaluator.processCheck(checkEvent, onDeny -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(onDeny);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        UseOnContext useOnContext = new UseOnContext(player, event.getHand(), event.getHitVec());
        BlockPos targetPos = useOnContext.m_8083_();
        BlockPos placeBlockTarget = targetPos.m_121945_(useOnContext.m_43719_().m_122424_());
        BlockEntity targetEntity = event.getLevel().m_7702_(event.getPos());
        InteractionHand usedHand = useOnContext.m_43724_();
        boolean hasEmptyHand = PlayerFlagHandler.hasEmptyHand(player, usedHand);
        ItemStack itemInHand = useOnContext.m_43722_();
        boolean isSneakingWithEmptyHand = player.m_6144_() && hasEmptyHand;
        boolean isBlockEntity = targetEntity instanceof BlockEntity;
        boolean isLockableTileEntity = targetEntity instanceof BaseContainerBlockEntity;
        boolean isEnderChest = targetEntity instanceof EnderChestBlockEntity;
        boolean isContainer = targetEntity instanceof LecternBlockEntity || isLockableTileEntity;
        BlockHitResult pos = event.getHitVec();
        if (isSneakingWithEmptyHand || !player.m_6144_()) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(pos.m_82425_(), RegionFlag.USE_BLOCKS, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
                event.getLevel().m_46672_(pos.m_82425_(), event.getLevel().m_8055_(pos.m_82425_()).m_60734_());
            });
            if (isEnderChest) {
                checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.ENDER_CHEST_ACCESS, HandlerUtil.getDimKey((Entity)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(onDeny);
                });
            }
            if (isContainer) {
                checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.CONTAINER_ACCESS, HandlerUtil.getDimKey((Entity)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(onDeny);
                });
            }
        }
        if (!hasEmptyHand) {
            FlagCheckEvent checkEvent;
            ResourceLocation itemRl = ForgeRegistries.ITEMS.getKey((Object)itemInHand.m_41720_());
            Set<String> entities = Services.FLAG_CONFIG.getCoveredBlockEntities();
            Set<String> entityTags = Services.FLAG_CONFIG.getCoveredBlockEntityTags();
            boolean isCoveredByTag = entityTags.stream().anyMatch(tag -> {
                ResourceLocation tagRl = ResourceLocation.parse((String)tag);
                return itemInHand.m_204131_().anyMatch(itemTagKey -> itemTagKey.f_203868_().equals((Object)tagRl));
            });
            boolean isBlockCovered = entities.stream().anyMatch(entity -> {
                ResourceLocation entityRl = ResourceLocation.parse((String)entity);
                return itemRl != null && itemRl.equals((Object)entityRl);
            });
            Consumer<FlagCheckResult> onDenyAction = denyResult -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(denyResult);
                player.m_150109_().m_6596_();
            };
            if (isBlockCovered || isCoveredByTag) {
                checkEvent = new FlagCheckEvent(placeBlockTarget, RegionFlag.PLACE_BLOCKS, HandlerUtil.getDimKey((Entity)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDenyAction);
            }
            if (Services.EVENT.post(checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.USE_ITEMS, HandlerUtil.getDimKey((Entity)player), player))) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDenyAction);
        }
    }

    @SubscribeEvent
    public static void onAccessEntityContainer(PlayerInteractEvent.EntityInteract event) {
        boolean hasInventory;
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        boolean bl = hasInventory = event.getTarget() instanceof Container || event.getTarget() instanceof MenuProvider;
        if (hasInventory) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getTarget().m_20183_(), RegionFlag.CONTAINER_ACCESS, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onEntityInteraction(PlayerInteractEvent.EntityInteractSpecific event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getTarget().m_20183_(), RegionFlag.USE_ENTITIES, HandlerUtil.getDimKey((Entity)player), player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
        if (!PlayerFlagHandler.hasEmptyHand(player, event.getHand())) {
            checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.USE_ITEMS, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    private static boolean hasEmptyHands(Player player) {
        return player.m_21120_(InteractionHand.MAIN_HAND).m_41720_().equals(Items.f_41852_) && player.m_21120_(InteractionHand.OFF_HAND).m_41720_().equals(Items.f_41852_);
    }

    private static boolean hasEmptyHand(Player player, InteractionHand hand) {
        return player.m_21120_(hand).m_41720_().equals(Items.f_41852_);
    }

    @SubscribeEvent
    public static void onEntityInteraction(PlayerInteractEvent.EntityInteract event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getTarget().m_20183_(), RegionFlag.USE_ENTITIES, HandlerUtil.getDimKey((Entity)player), player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
        if (!PlayerFlagHandler.hasEmptyHand(player, event.getHand())) {
            checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.USE_ENTITIES, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onEntityInteraction(PlayerInteractEvent.RightClickItem event) {
        FlagCheckEvent checkEvent;
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        if (!PlayerFlagHandler.hasEmptyHand(player, event.getHand())) {
            checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.USE_ENTITIES, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
        if (Services.EVENT.post(checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.USE_ITEMS, HandlerUtil.getDimKey((Entity)player), player))) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onSteppedOnActivator(BlockEvent.NeighborNotifyEvent event) {
        if (ForgeHandlerUtil.isServerSide((BlockEvent)event)) {
            Block block = event.getLevel().m_8055_(event.getPos()).m_60734_();
            BlockPos pos = event.getPos();
            if (block instanceof BasePressurePlateBlock) {
                AABB areaAbovePressurePlate = new AABB((double)(pos.m_123341_() - 1), (double)pos.m_123342_(), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 1));
                List players = event.getLevel().m_142425_((EntityTypeTest)EntityType.f_20532_, areaAbovePressurePlate, player -> true);
                FlagState[] cumulativeState = new FlagState[]{FlagState.UNDEFINED};
                HashMap<Player, FlagCheckEvent> playerCheckEventMap = new HashMap<Player, FlagCheckEvent>();
                for (Player player2 : players) {
                    FlagCheckEvent checkEvent = new FlagCheckEvent(player2.m_20183_(), RegionFlag.USE_BLOCKS, HandlerUtil.getDimKey((Entity)player2), player2);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    playerCheckEventMap.put(player2, checkEvent);
                }
                for (Map.Entry entry : playerCheckEventMap.entrySet()) {
                    FlagState state = FlagEvaluator.processCheck((FlagCheckEvent)entry.getValue(), null, MessageSender::sendFlagMsg);
                    if (state != FlagState.DENIED) continue;
                    cumulativeState[0] = state;
                }
                if (cumulativeState[0] == FlagState.DENIED) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBucketFill(FillBucketEvent event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        if (event.getTarget() != null) {
            HitResult pos = event.getTarget();
            BlockPos targetPos = new BlockPos((int)event.getTarget().m_82450_().f_82479_, (int)event.getTarget().m_82450_().f_82480_, (int)event.getTarget().m_82450_().f_82481_);
            int bucketItemMaxStackCount = event.getEmptyBucket().m_41741_();
            if (bucketItemMaxStackCount == 1) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(targetPos, RegionFlag.PLACE_FLUIDS, HandlerUtil.getDimKey((Entity)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(onDeny);
                });
            }
            if (bucketItemMaxStackCount > 1) {
                boolean isWaterlogged = false;
                boolean isFluid = false;
                if (pos != null && pos.m_6662_() == HitResult.Type.BLOCK) {
                    ITagManager tags;
                    BlockState blockState = event.getLevel().m_8055_(targetPos);
                    if (blockState.m_60734_() instanceof SimpleWaterloggedBlock) {
                        isWaterlogged = (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_);
                    }
                    if ((tags = ForgeRegistries.FLUIDS.tags()) != null) {
                        isFluid = tags.getTagNames().anyMatch(tag -> blockState.m_60819_().m_205070_(tag));
                    }
                    if (isWaterlogged || isFluid) {
                        FlagCheckEvent checkEvent = new FlagCheckEvent(targetPos, RegionFlag.SCOOP_FLUIDS, HandlerUtil.getDimKey((Entity)player), player);
                        if (Services.EVENT.post(checkEvent)) {
                            return;
                        }
                        FlagEvaluator.processCheck(checkEvent, onDeny -> {
                            event.setCanceled(true);
                            MessageSender.sendFlagMsg(onDeny);
                        });
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSendChat(ServerChatEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ServerPlayer player = event.getPlayer();
        FlagCheckEvent checkEvent = new FlagCheckEvent(player.m_20183_(), RegionFlag.SEND_MESSAGE, HandlerUtil.getDimKey((Entity)player), (Player)player);
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, onDeny -> {
            event.setCanceled(true);
            MessageSender.sendFlagMsg(onDeny);
        });
    }

    @SubscribeEvent
    public static void onCommandSend(CommandEvent event) {
        try {
            ServerPlayer player = ((CommandSourceStack)event.getParseResults().getContext().getSource()).m_81375_();
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.m_20183_(), RegionFlag.EXECUTE_COMMAND, HandlerUtil.getDimKey((Entity)player), (Player)player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onPlayerAttemptSleep(SleepingTimeCheckEvent event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        event.getSleepingLocation().ifPresent(pos -> {
            FlagCheckEvent checkEvent = new FlagCheckEvent((BlockPos)pos, RegionFlag.SLEEP, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setResult(Event.Result.DENY);
                MessageSender.sendFlagMsg(onDeny);
            });
        });
    }

    @SubscribeEvent
    public static void onSetSpawn(PlayerSetSpawnEvent event) {
        if (HandlerUtil.notServerSideOrPlayerNull((Entity)event.getEntity())) {
            return;
        }
        BlockPos newSpawn = event.getNewSpawn();
        Player player = event.getEntity();
        if (newSpawn != null) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(newSpawn, RegionFlag.SET_SPAWN, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerDropItem(ItemTossEvent event) {
        if (!event.getPlayer().m_20193_().f_46443_) {
            Player player = event.getPlayer();
            if (player == null) {
                return;
            }
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getEntity().m_20183_(), RegionFlag.ITEM_DROP, HandlerUtil.getDimKey((Entity)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, onDeny -> {
                event.setCanceled(true);
                player.m_36356_(event.getEntity().m_32055_());
                player.m_150109_().m_6596_();
                MessageSender.sendFlagMsg(onDeny);
            });
        }
    }

    @SubscribeEvent
    public static void onEntityMountAttempt(EntityMountEvent event) {
        if (ForgeHandlerUtil.isServerSide((EntityEvent)event)) {
            Entity entityBeingMounted = event.getEntityBeingMounted();
            Entity entity = event.getEntityMounting();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                FlagCheckEvent checkEvent = new FlagCheckEvent(entityBeingMounted.m_20183_(), RegionFlag.ANIMAL_MOUNTING, HandlerUtil.getDimKey((Entity)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, onDeny -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(onDeny);
                });
                if (event.isDismounting()) {
                    checkEvent = new FlagCheckEvent(entityBeingMounted.m_20183_(), RegionFlag.ANIMAL_UNMOUNTING, HandlerUtil.getDimKey((Entity)player), player);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, onDeny -> {
                        event.setCanceled(true);
                        MessageSender.sendFlagMsg(onDeny);
                    });
                }
            }
        }
    }
}

