/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.handler.flags;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.handler.flags.ForgeHandlerUtil;
import de.z0rdak.yawp.platform.Services;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="yawp", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldFlagHandler {
    private WorldFlagHandler() {
    }

    @SubscribeEvent
    public static void onLightningStrikeOccur(EntityStruckByLightningEvent event) {
        if (ForgeHandlerUtil.isServerSide((EntityEvent)event)) {
            Entity poorEntity = event.getEntity();
            FlagCheckEvent checkEvent = new FlagCheckEvent(poorEntity.m_20183_(), RegionFlag.LIGHTNING_PROT, (ResourceKey<Level>)event.getEntity().m_9236_().m_46472_());
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, denyResult -> {
                event.setCanceled(true);
                event.getLightning().m_142687_(Entity.RemovalReason.DISCARDED);
            });
        }
    }

    @SubscribeEvent
    public static void onItemExpire(ItemExpireEvent event) {
        FlagCheckEvent checkEvent = new FlagCheckEvent(event.getEntity().m_20183_(), RegionFlag.NO_ITEM_DESPAWN, (ResourceKey<Level>)event.getEntity().m_9236_().m_46472_());
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, deny -> {
            event.setCanceled(true);
            event.setExtraLife(6000);
        });
    }

    @SubscribeEvent
    public static void onNetherPortalSpawn(BlockEvent.PortalSpawnEvent event) {
        Level world = (Level)event.getLevel();
        if (HandlerUtil.isServerSide(world)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.SPAWN_PORTAL, (ResourceKey<Level>)world.m_46472_());
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> event.setCanceled(true));
        }
    }

    @SubscribeEvent
    public static void onUsePortal(EntityTravelToDimensionEvent event) {
        if (HandlerUtil.isServerSide(event.getEntity())) {
            Player player;
            Entity entity = event.getEntity();
            ResourceKey dimension = event.getEntity().m_9236_().m_46472_();
            BlockPos target = entity.m_20183_();
            FlagCheckEvent checkEvent = new FlagCheckEvent(target, RegionFlag.USE_PORTAL, (ResourceKey<Level>)dimension, player = entity instanceof Player ? (Player)entity : null);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, denyResult -> event.setCanceled(true));
            if (entity instanceof Player) {
                checkEvent = new FlagCheckEvent(target, RegionFlag.USE_PORTAL_PLAYERS, (ResourceKey<Level>)dimension, player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, denyResult -> event.setCanceled(true));
            } else {
                checkEvent = WorldFlagHandler.getNonPlayerCheckEventFor(entity, target, (ResourceKey<Level>)dimension);
                if (checkEvent != null) {
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, denyResult -> event.setCanceled(true));
                }
            }
        }
    }

    @Nullable
    @Deprecated
    private static FlagCheckEvent getNonPlayerCheckEventFor(Entity entity, BlockPos target, ResourceKey<Level> dimension) {
        FlagCheckEvent nonPlayerCheckEvent = null;
        if (entity instanceof ItemEntity) {
            nonPlayerCheckEvent = new FlagCheckEvent(target, RegionFlag.USE_PORTAL_ITEMS, dimension);
        }
        if (HandlerUtil.isAnimal(entity)) {
            nonPlayerCheckEvent = new FlagCheckEvent(target, RegionFlag.USE_PORTAL_ANIMALS, dimension);
        }
        if (HandlerUtil.isMonster(entity)) {
            nonPlayerCheckEvent = new FlagCheckEvent(target, RegionFlag.USE_PORTAL_MONSTERS, dimension);
        }
        if (entity instanceof AbstractVillager) {
            nonPlayerCheckEvent = new FlagCheckEvent(target, RegionFlag.USE_PORTAL_VILLAGERS, dimension);
        }
        if (entity instanceof AbstractMinecart) {
            nonPlayerCheckEvent = new FlagCheckEvent(target, RegionFlag.USE_PORTAL_MINECARTS, dimension);
        }
        return nonPlayerCheckEvent;
    }

    @SubscribeEvent
    public static void onTravelToDim(EntityTravelToDimensionEvent event) {
        Entity entity;
        if (HandlerUtil.isServerSide(event.getEntity()) && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            ResourceKey dim = event.getDimension();
            ServerLevel targetServerLevel = player.m_20194_().m_129880_(dim);
            if (targetServerLevel != null) {
                FlagCheckEvent checkGeneralEvent = new FlagCheckEvent(player.m_20183_(), RegionFlag.ENTER_DIM, (ResourceKey<Level>)dim, player);
                if (Services.EVENT.post(checkGeneralEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkGeneralEvent, denyResult -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(denyResult);
                });
            }
        }
    }
}

