/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.CommandInterceptor;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Commands.class})
public abstract class CommandManagerMixin {
    @Inject(method={"performCommand"}, at={@At(value="HEAD")}, cancellable=true)
    public void execute(ParseResults<CommandSourceStack> parseResults, String command, CallbackInfoReturnable<Integer> cir) {
        ServerPlayer player;
        CommandSourceStack cmdSource;
        int result = 0;
        try {
            result = CommandInterceptor.handleModCommands(parseResults, command);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (result != 0) {
            cir.setReturnValue((Object)1);
        }
        if ((cmdSource = (CommandSourceStack)parseResults.getContext().getSource()).m_230897_() && (player = cmdSource.m_230896_()) != null) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.m_20183_(), RegionFlag.EXECUTE_COMMAND, HandlerUtil.getDimKey((Entity)player), (Player)player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                cir.setReturnValue((Object)1);
            });
        }
    }
}

