/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.level.material.WaterFluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FlowingFluid.class})
public class FlowingFluidMixin {
    @Inject(method={"canSpreadTo"}, at={@At(value="HEAD")}, cancellable=true)
    protected void canSpreadTo(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Direction direction, BlockPos blockPos2, BlockState blockState2, FluidState fluidState, Fluid fluid, CallbackInfoReturnable<Boolean> cir) {
        FlagCheckEvent specificFluidCheckEvent;
        if (!(blockGetter instanceof Level)) {
            return;
        }
        Level level = (Level)blockGetter;
        if (!Services.FLAG_CONFIG.isDisabledByConfig(RegionFlag.FLUID_FLOW.name)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, RegionFlag.FLUID_FLOW, (ResourceKey<Level>)level.m_46472_());
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue((Object)false));
            if (cir.isCancelled()) {
                return;
            }
        }
        if (!Services.FLAG_CONFIG.isDisabledByConfig(RegionFlag.WATER_FLOW.name) && fluidState.m_76152_() instanceof WaterFluid) {
            specificFluidCheckEvent = new FlagCheckEvent(blockPos, RegionFlag.WATER_FLOW, (ResourceKey<Level>)level.m_46472_());
            if (Services.EVENT.post(specificFluidCheckEvent)) {
                return;
            }
            FlagEvaluator.processCheck(specificFluidCheckEvent, deny -> cir.setReturnValue((Object)false));
        }
        if (!Services.FLAG_CONFIG.isDisabledByConfig(RegionFlag.LAVA_FLOW.name) && fluidState.m_76152_() instanceof LavaFluid) {
            specificFluidCheckEvent = new FlagCheckEvent(blockPos, RegionFlag.LAVA_FLOW, (ResourceKey<Level>)level.m_46472_());
            if (Services.EVENT.post(specificFluidCheckEvent)) {
                return;
            }
            FlagEvaluator.processCheck(specificFluidCheckEvent, deny -> cir.setReturnValue((Object)false));
        }
    }
}

