/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util;

import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public final class AreaUtil {
    private AreaUtil() {
    }

    public static double distance(BlockPos a, BlockPos b) {
        return Math.sqrt(Math.pow(b.m_123341_() - a.m_123341_(), 2.0) + Math.pow(b.m_123342_() - a.m_123342_(), 2.0) + Math.pow(b.m_123343_() - a.m_123343_(), 2.0));
    }

    public static int distanceManhattan(BlockPos a, BlockPos b) {
        return Math.abs(b.m_123341_() - a.m_123341_()) + Math.abs(b.m_123342_() - a.m_123342_()) + Math.abs(b.m_123343_() - a.m_123343_());
    }

    public static double length(BlockPos a) {
        return Math.sqrt(Math.pow(a.m_123341_(), 2.0) + Math.pow(a.m_123342_(), 2.0) + Math.pow(a.m_123343_(), 2.0));
    }

    public static String blockPosStr(BlockPos pos) {
        return new StringJoiner(", ", "[", "]").add(String.valueOf(pos.m_123341_())).add(String.valueOf(pos.m_123342_())).add(String.valueOf(pos.m_123343_())).toString();
    }

    public static BlockPos getLowerPos(BlockPos pos1, BlockPos pos2) {
        return pos1.m_123343_() < pos2.m_123343_() ? pos1 : pos2;
    }

    public static BlockPos getHigherPos(BlockPos pos1, BlockPos pos2) {
        return pos1.m_123343_() > pos2.m_123343_() ? pos1 : pos2;
    }

    public static Set<BlockPos> getBoundingBoxFrame(BoundingBox box) {
        BlockPos[] corners = new BlockPos[]{new BlockPos(box.m_162395_(), box.m_162396_(), box.m_162398_()), new BlockPos(box.m_162395_(), box.m_162396_(), box.m_162401_()), new BlockPos(box.m_162395_(), box.m_162400_(), box.m_162398_()), new BlockPos(box.m_162395_(), box.m_162400_(), box.m_162401_()), new BlockPos(box.m_162399_(), box.m_162396_(), box.m_162398_()), new BlockPos(box.m_162399_(), box.m_162396_(), box.m_162401_()), new BlockPos(box.m_162399_(), box.m_162400_(), box.m_162398_()), new BlockPos(box.m_162399_(), box.m_162400_(), box.m_162401_())};
        int[][] edgePairs = new int[][]{{0, 1}, {0, 2}, {0, 4}, {1, 3}, {1, 5}, {2, 3}, {2, 6}, {3, 7}, {4, 5}, {4, 6}, {5, 7}, {6, 7}};
        HashSet<BlockPos> frame = new HashSet<BlockPos>();
        for (int[] pair : edgePairs) {
            frame.addAll(AreaUtil.getEdge(corners[pair[0]], corners[pair[1]]));
        }
        return frame;
    }

    public static Set<BlockPos> getEdge(BlockPos a, BlockPos b) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        int dx = Integer.compare(b.m_123341_(), a.m_123341_());
        int dy = Integer.compare(b.m_123342_(), a.m_123342_());
        int dz = Integer.compare(b.m_123343_(), a.m_123343_());
        BlockPos current = a;
        result.add(current);
        while (!current.equals((Object)b)) {
            current = current.m_7918_(dx, dy, dz);
            result.add(current);
        }
        return result;
    }

    public static Set<BlockPos> blocksBetweenOnAxis(BlockPos p1, BlockPos p2, Direction.Axis axis) {
        BoundingBox blockLine = BoundingBox.m_162375_((Vec3i)p1, (Vec3i)p2);
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        switch (axis) {
            case X: {
                for (int x = blockLine.m_162395_(); x <= blockLine.m_162399_(); ++x) {
                    blocks.add(new BlockPos(x, p1.m_123342_(), p1.m_123343_()));
                }
                break;
            }
            case Y: {
                for (int y = blockLine.m_162396_(); y <= blockLine.m_162400_(); ++y) {
                    blocks.add(new BlockPos(p1.m_123341_(), y, p1.m_123343_()));
                }
                break;
            }
            case Z: {
                for (int z = blockLine.m_162398_(); z <= blockLine.m_162401_(); ++z) {
                    blocks.add(new BlockPos(p1.m_123341_(), p1.m_123342_(), z));
                }
                break;
            }
        }
        return blocks;
    }

    public static Set<BlockPos> blocksIn(BoundingBox cube) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int x = cube.m_162395_(); x <= cube.m_162399_(); ++x) {
            for (int y = cube.m_162396_(); y <= cube.m_162400_(); ++y) {
                for (int z = cube.m_162398_(); z <= cube.m_162401_(); ++z) {
                    blocks.add(new BlockPos(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static Set<BlockPos> blocksIn(BoundingBox cube, Predicate<BlockPos> inclusion) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int x = cube.m_162395_(); x <= cube.m_162399_(); ++x) {
            for (int y = cube.m_162396_(); y <= cube.m_162400_(); ++y) {
                for (int z = cube.m_162398_(); z <= cube.m_162401_(); ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    if (!inclusion.test(blockPos)) continue;
                    blocks.add(blockPos);
                }
            }
        }
        return blocks;
    }

    public static int blocksOnAxis(BoundingBox box, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return box.m_71056_();
            }
            case Y: {
                return box.m_71057_();
            }
            case Z: {
                return box.m_71058_();
            }
        }
        throw new IllegalArgumentException();
    }

    public static BoundingBox getSlice(BlockPos center, int halfSize, int offset, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                BlockPos p1 = center.m_7918_(halfSize, halfSize, offset);
                BlockPos p2 = center.m_7918_(-halfSize, -halfSize, offset);
                yield BoundingBox.m_162375_((Vec3i)p1, (Vec3i)p2);
            }
            case Direction.Axis.Y -> {
                BlockPos p1 = center.m_7918_(halfSize, offset, halfSize);
                BlockPos p2 = center.m_7918_(-halfSize, offset, -halfSize);
                yield BoundingBox.m_162375_((Vec3i)p1, (Vec3i)p2);
            }
            case Direction.Axis.Z -> {
                BlockPos p1 = center.m_7918_(offset, halfSize, halfSize);
                BlockPos p2 = center.m_7918_(offset, -halfSize, -halfSize);
                yield BoundingBox.m_162375_((Vec3i)p1, (Vec3i)p2);
            }
        };
    }

    public static Set<BlockPos> getSliceBlocks(BlockPos center, int halfSize, int offset, Direction.Axis axis, Predicate<BlockPos> include) {
        BoundingBox slice = AreaUtil.getSlice(center, halfSize, offset, axis);
        return AreaUtil.blocksIn(slice, include);
    }
}

