/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.flag.FlagCorrelation;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.group.GroupType;
import de.z0rdak.yawp.core.group.PlayerContainer;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.text.Messages;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.NotImplementedException;

public class ChatLinkBuilder {
    private ChatLinkBuilder() {
    }

    public static MutableComponent buildAreaMarkedBlocksTpLinks(IMarkableRegion region) {
        List<MutableComponent> tpLinks = region.getArea().markedBlocks().stream().map(pos -> ChatLinkBuilder.buildDimensionalBlockTpLink(region.getDim(), pos, Component.m_237113_((String)ChatComponentBuilder.commandBlockPosStr(pos)))).toList();
        MutableComponent blockPosTpLinkList = Component.m_237113_((String)"");
        tpLinks.forEach(tpLink -> blockPosTpLinkList.m_7220_((Component)tpLink).m_130946_(" "));
        return blockPosTpLinkList;
    }

    public static MutableComponent buildRegionAreaExpandLink(IMarkableRegion region) {
        MutableComponent linkText = Component.m_264568_((String)"cli.msg.info.region.area.area.expand.link.text", (String)"<=expand=>");
        MutableComponent linkHover = Component.m_264642_((String)"cli.msg.info.region.area.area.expand.link.hover", (String)"Expand the area for '%s'", (Object[])new Object[]{region.getName()});
        String expandCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().m_135782_().toString(), region.getName(), CommandConstants.AREA.toString(), CommandConstants.EXPAND.toString(), region.getArea().getAreaType().areaType);
        switch (region.getArea().getAreaType()) {
            case CUBOID: {
                CuboidArea cuboidArea = (CuboidArea)region.getArea();
                int areaLowerLimit = cuboidArea.getArea().m_162396_();
                int areaUpperLimit = cuboidArea.getArea().m_162400_();
                String expandCmdSuggestion = Commands.appendSubCommand(expandCmd, String.valueOf(areaLowerLimit), String.valueOf(areaUpperLimit));
                MutableComponent expandLink = ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, linkHover, expandCmdSuggestion, ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
                MutableComponent maxExpandLinkText = Component.m_264568_((String)"cli.msg.info.region.area.area.expand-max.link.text", (String)"<=max=>");
                MutableComponent maxExpandLinkHover = Component.m_264568_((String)"cli.msg.info.region.area.area.expand-max.link.hover", (String)"Expand area to build limit");
                String maxExpandCmd = Commands.appendSubCommand(expandCmd, String.valueOf(-64), String.valueOf(320));
                MutableComponent maxExpandLink = ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(maxExpandLinkText, maxExpandLinkHover, maxExpandCmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
                return Messages.substitutable("%s %s", expandLink, maxExpandLink);
            }
            case CYLINDER: {
                throw new NotImplementedException("cylinder");
            }
            case SPHERE: {
                String expandCmdSuggestion = Commands.appendSubCommand(expandCmd, String.valueOf(1));
                return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, linkHover, expandCmdSuggestion, ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
            }
            case POLYGON_3D: {
                throw new NotImplementedException("polygon");
            }
            case PRISM: {
                throw new NotImplementedException("prism");
            }
        }
        throw new IllegalArgumentException("Invalid area type");
    }

    private static MutableComponent buildShowAreaToggleLink(IMarkableRegion region) {
        MutableComponent showAreaLinkText = Component.m_264568_((String)"cli.msg.info.region.area.area.show.link", (String)"Show");
        MutableComponent showAreaLinkHover = Component.m_264642_((String)"cli.msg.info.region.area.area.show.hover", (String)"Toggle visible bounding box of '%s'", (Object[])new Object[]{region.getName()});
        String showAreaCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().m_135782_().toString(), region.getName(), CommandConstants.AREA.toString(), "show");
        return ChatComponentBuilder.buildExecuteCmdComponent(showAreaLinkText, showAreaLinkHover, showAreaCmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildAreaUpdateLink(IMarkableRegion region) {
        MutableComponent setAreaLinkText = Component.m_264568_((String)"cli.msg.info.region.area.area.set.link", (String)"set area");
        MutableComponent setAreaLinkHover = Component.m_264642_((String)"cli.msg.info.region.area.area.set.hover", (String)"Update area of region '%s'", (Object[])new Object[]{region.getName()});
        String blocks = String.join((CharSequence)" ", region.getArea().markedBlocks().stream().map(ChatComponentBuilder::commandBlockPosStr).collect(Collectors.toSet()));
        String setAreaCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().m_135782_().toString(), region.getName(), CommandConstants.AREA.toString(), CommandConstants.SET.toString(), region.getArea().getAreaType().areaType, blocks);
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(setAreaLinkText, setAreaLinkHover, setAreaCmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildRegionAreaActionLinks(IMarkableRegion region) {
        MutableComponent text = Component.m_264568_((String)"cli.msg.info.region.area.show.link.text", (String)"show area");
        return Messages.substitutable("%s %s %s", ChatLinkBuilder.buildAreaUpdateLink(region), ChatLinkBuilder.buildRegionShowVisualizationLink(region, text), ChatLinkBuilder.buildRegionAreaExpandLink(region));
    }

    public static MutableComponent buildWikiLink() {
        MutableComponent wikiLinkHover = Component.m_264568_((String)"help.tooltip.wiki.link.hover", (String)"https://github.com/Z0rdak/Yet-Another-Level-Protector/wiki");
        MutableComponent wikiLink = Component.m_264568_((String)"help.tooltip.wiki.link.text", (String)"Open Wiki in default browser");
        return ChatComponentBuilder.buildExecuteCmdComponent(wikiLink, wikiLinkHover, "https://github.com/Z0rdak/Yet-Another-World-Protector/wiki", ClickEvent.Action.OPEN_URL, ChatFormatting.AQUA);
    }

    public static MutableComponent buildRegionInfoLink(IProtectedRegion region) {
        return ChatLinkBuilder.buildRegionInfoLink(region, Component.m_264642_((String)"cli.msg.info.region.link.hover", (String)"Show region info for %s", (Object[])new Object[]{region.getName()}));
    }

    public static MutableComponent buildRegionInfoLink(IProtectedRegion region, MutableComponent linkText, MutableComponent hoverText) {
        String cmd = Commands.buildRegionInfoCmd(region);
        return ChatComponentBuilder.buildExecuteCmdLink(linkText, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildRegionInfoLink(IProtectedRegion region, MutableComponent hoverText) {
        MutableComponent linkText = Component.m_237113_((String)region.getName());
        return ChatLinkBuilder.buildRegionInfoLink(region, linkText, hoverText);
    }

    public static MutableComponent buildRegionAreaLink(IMarkableRegion region) {
        String showSpatialPropLink = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().m_135782_().toString(), region.getName(), CommandConstants.AREA.toString());
        MutableComponent spatialPropLinkText = Component.m_264568_((String)"cli.msg.info.region.area.link.text", (String)"Area Properties");
        MutableComponent spatialPropHoverText = Component.m_264642_((String)"cli.msg.info.region.area.link.hover", (String)"Show region area properties for %s", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLink(spatialPropLinkText, spatialPropHoverText, showSpatialPropLink, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildDisplaySettingsLink(IMarkableRegion region) {
        MutableComponent text = Component.m_264568_((String)"cli.msg.info.region.display.link.text", (String)"Display settings");
        return ChatLinkBuilder.buildDisplaySettingsLink(region, text);
    }

    public static MutableComponent buildRegionShowVisualizationLink(IMarkableRegion region, MutableComponent text) {
        String showDisplayPropLink = Commands.buildShowCommand(region);
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.visualization.link.hover", (String)"Click to show visualization options for '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, showDisplayPropLink, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildRegionVisualizationLink(IMarkableRegion region) {
        String showDisplayPropLink = Commands.buildShowCommand(region);
        MutableComponent text = Component.m_264568_((String)"cli.msg.info.region.visualization.link.text", (String)"Visualization");
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.visualization.link.hover", (String)"Click to show visualization options for '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLink(text, hover, showDisplayPropLink, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildDisplaySettingsLink(IMarkableRegion region, MutableComponent text) {
        String showDisplayPropLink = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().m_135782_().toString(), region.getName(), CommandConstants.DISPLAY.toString());
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.display.link.hover", (String)"Click to show display settings for '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLink(text, hover, showDisplayPropLink, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildGroupLink(IProtectedRegion region, String group, int groupSize) {
        MutableComponent linkText = Component.m_264642_((String)"cli.msg.info.region.group.list.link.text", (String)"%s %s(s)", (Object[])new Object[]{groupSize, group});
        MutableComponent hoverText = Component.m_264642_((String)"cli.msg.info.region.group.list.link.hover", (String)"List '%s' for region %s", (Object[])new Object[]{group, region.getName()});
        String cmd = Commands.buildListGroupCommand(region, group);
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildPlayerListLink(IProtectedRegion region, PlayerContainer players, String group) {
        MutableComponent hoverText = Component.m_264642_((String)"cli.msg.info.region.group.player.list.link.hover", (String)"List players of group '%s' in region %s", (Object[])new Object[]{group, region.getName()});
        MutableComponent linkText = Component.m_264642_((String)"cli.msg.info.region.group.player.list.link.text", (String)"%s player(s)", (Object[])new Object[]{players.getPlayers().size()});
        String cmd = Commands.buildListGroupMemberCommand(region, group, GroupType.PLAYER);
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildTeamListLink(IProtectedRegion region, PlayerContainer teams, String group) {
        MutableComponent hoverText = Component.m_264642_((String)"cli.msg.info.region.group.team.list.link.hover", (String)"List teams of group '%s' in region %s", (Object[])new Object[]{group, region.getName()});
        MutableComponent linkText = Component.m_264642_((String)"cli.msg.info.region.group.team.list.link.text", (String)"%s team(s)", (Object[])new Object[]{teams.getTeams().size()});
        String cmd = Commands.buildListGroupMemberCommand(region, group, GroupType.TEAM);
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildAddToGroupLink(IProtectedRegion region, String group, GroupType groupType) {
        MutableComponent linkText = Component.m_264568_((String)"cli.link.add", (String)"+");
        String fallback = "Add " + groupType.name + " as '%s' to region %s";
        MutableComponent hoverText = Component.m_264642_((String)("cli.msg.info.region.group." + groupType.name + ".add.link.hover"), (String)fallback, (Object[])new Object[]{group, region.getName()});
        String cmd = Commands.buildAddGroupMemberCommand(region, groupType, group, "");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, hoverText, cmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildGroupTeamListLink(IProtectedRegion region, String group) {
        PlayerContainer playerContainer = region.getGroup(group);
        MutableComponent teamAddLink = ChatLinkBuilder.buildAddToGroupLink(region, group, GroupType.TEAM);
        MutableComponent teamListLink = playerContainer.hasTeams() ? ChatLinkBuilder.buildTeamListLink(region, playerContainer, group) : Component.m_264642_((String)"cli.msg.info.region.group.team.list.link.text", (String)"%s team(s)", (Object[])new Object[]{playerContainer.getTeams().size()});
        return Messages.substitutable("%s: %s %s", Component.m_264568_((String)"cli.msg.info.region.group.team", (String)"Teams"), teamListLink, teamAddLink);
    }

    public static MutableComponent buildGroupPlayerListLink(IProtectedRegion region, String group) {
        PlayerContainer playerContainer = region.getGroup(group);
        MutableComponent playersAddLink = ChatLinkBuilder.buildAddToGroupLink(region, group, GroupType.PLAYER);
        MutableComponent playerListLink = playerContainer.hasPlayers() ? ChatLinkBuilder.buildPlayerListLink(region, playerContainer, group) : Component.m_264642_((String)"cli.msg.info.region.group.player.list.link.text", (String)"%s player(s)", (Object[])new Object[]{playerContainer.getPlayers().size()});
        return Messages.substitutable("%s: %s %s", Component.m_264568_((String)"cli.msg.info.region.group.player", (String)"Players"), playerListLink, playersAddLink);
    }

    public static MutableComponent buildFlagInfoLink(IProtectedRegion region, IFlag flag, ChatFormatting linkColor) {
        MutableComponent text = Component.m_237113_((String)flag.getName());
        MutableComponent hoverText = Component.m_264642_((String)"cli.flag.info.hover", (String)"Show %s flag info of region '%s'", (Object[])new Object[]{flag.getName(), region.getName()});
        return ChatLinkBuilder.buildFlagInfoLink(region, flag, text, hoverText, linkColor);
    }

    public static MutableComponent buildFlagInfoLink(IProtectedRegion region, IFlag flag, MutableComponent text, MutableComponent hoverText, ChatFormatting linkColor) {
        String cmd = Commands.buildFlagInfoCmd(region, flag.getName());
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, linkColor);
    }

    public static MutableComponent buildFlagInfoLink(IProtectedRegion region, IFlag flag) {
        return ChatLinkBuilder.buildFlagInfoLink(region, flag, Messages.LINK_COLOR);
    }

    public static MutableComponent buildFlagStateSuggestionLink(IProtectedRegion region, IFlag flag) {
        MutableComponent hover = Component.m_264642_((String)"cli.flag.state.set.link.hover", (String)"Set flag state for '%s' in '%s'", (Object[])new Object[]{flag.getName(), region.getName()});
        MutableComponent text = Component.m_264568_((String)"cli.flag.state.set.link.text", (String)"s");
        String cmd = Commands.buildFlagSuggestStateCmd(region, flag.getName());
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, cmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildFlagOverrideToggleLink(IProtectedRegion region, IFlag flag, boolean shortLink) {
        String fallback = flag.doesOverride() ? "active" : "inactive";
        String fallbackHover = (flag.doesOverride() ? "Disable" : "Enable") + " flag override for '%s' of '%s'";
        MutableComponent linkText = Component.m_264568_((String)("cli.flag.override.link.text." + flag.doesOverride()), (String)fallback);
        MutableComponent hoverText = Component.m_264642_((String)("cli.flag.override.link.hover." + flag.doesOverride()), (String)fallbackHover, (Object[])new Object[]{flag.getName(), region.getName()});
        if (shortLink) {
            linkText = Component.m_264568_((String)"cli.flag.override.link.text.toggle", (String)"o");
        }
        ChatFormatting color = flag.doesOverride() ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        String cmd = Commands.buildFlagOverrideToggleCmd(region, flag.getName());
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, color);
    }

    public static MutableComponent buildFlagMessageEditLink(IProtectedRegion region, IFlag flag) {
        MutableComponent hover = Component.m_264642_((String)"cli.flag.msg.text.set.link.hover", (String)"Change the message shown when the flag '%s' of '%s' is triggered", (Object[])new Object[]{flag.getName(), region.getName()});
        MutableComponent text = Component.m_264568_((String)"cli.flag.msg.text.set.link.text", (String)"Edit");
        String msg = "\"" + flag.getFlagMsg().msg() + "\"";
        String cmd = Commands.buildFlagMsgSetCmd(region, flag.getName(), msg);
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildFlagMessageClearLink(IProtectedRegion region, IFlag flag) {
        MutableComponent hover = Component.m_264642_((String)"cli.flag.msg.text.set.default", (String)"Reset flag message for flag '%s' of '%s' to config default", (Object[])new Object[]{flag.getName(), region.getName()});
        MutableComponent text = Component.m_264568_((String)"cli.link.remove", (String)"x");
        String cmd = Commands.buildFlagMsgClearCmd(region, flag.getName());
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, ClickEvent.Action.RUN_COMMAND, Messages.REMOVE_CMD_COLOR);
    }

    public static MutableComponent buildFlagMuteToggleLink(IProtectedRegion region, IFlag flag, boolean shortLink) {
        String fallback = !flag.getFlagMsg().isMuted() ? "inactive" : "active";
        MutableComponent hover = Component.m_264642_((String)"cli.flag.msg.mute.set.link.hover", (String)"Activate flag alert for '%s' in '%s'", (Object[])new Object[]{flag.getName(), region.getName()});
        MutableComponent text = Component.m_264568_((String)("cli.flag.msg.mute.set.link.text." + !flag.getFlagMsg().isMuted()), (String)fallback);
        if (shortLink) {
            text = Component.m_264568_((String)"cli.flag.msg.mute.set.link.text.toggle", (String)"m");
        }
        ChatFormatting textChatFormatting = !flag.getFlagMsg().isMuted() ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        String cmd = Commands.buildFlagMsgMuteToggleCmd(region, flag.getName());
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, ClickEvent.Action.RUN_COMMAND, textChatFormatting);
    }

    public static MutableComponent buildRemoveAllRegionsAttemptLink(LevelRegionData levelRegionData) {
        String cmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), levelRegionData.getDim().getName(), CommandConstants.DELETE_ALL.toString(), CommandConstants.REGIONS.toString());
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.dim.region.remove.all.link.hover", (String)"Remove all regions from %s", (Object[])new Object[]{levelRegionData.getDim().getName()});
        MutableComponent text = Component.m_264568_((String)"cli.link.remove", (String)"x");
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, ClickEvent.Action.RUN_COMMAND, Messages.REMOVE_CMD_COLOR);
    }

    public static MutableComponent buildRemoveAllRegionsLink(LevelRegionData levelRegionData) {
        String cmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), levelRegionData.getDim().getName(), CommandConstants.DELETE_ALL.toString(), CommandConstants.REGIONS.toString(), CommandConstants.FOREVER.toString(), CommandConstants.SERIOUSLY.toString());
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.dim.region.remove.all.link.hover", (String)"Remove all regions from %s", (Object[])new Object[]{levelRegionData.getDim().getName()});
        MutableComponent text = Component.m_264568_((String)"cli.link.remove", (String)"x");
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, ClickEvent.Action.RUN_COMMAND, Messages.REMOVE_CMD_COLOR);
    }

    public static MutableComponent buildRemoveRegionLink(IProtectedRegion region) {
        String cmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), region.getDim().m_135782_().toString(), CommandConstants.DELETE.toString(), region.getName(), "-y");
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.dim.region.remove.link.hover", (String)"Remove region %s", (Object[])new Object[]{region.getName()});
        MutableComponent text = Component.m_264568_((String)"cli.link.remove", (String)"x");
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, ClickEvent.Action.RUN_COMMAND, Messages.REMOVE_CMD_COLOR);
    }

    public static MutableComponent buildParentClearLink(IMarkableRegion region) {
        String clearRegionParentCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().m_135782_().toString(), region.getName(), CommandConstants.PARENT.toString(), CommandConstants.REMOVE.toString());
        MutableComponent parentClearLinkText = Component.m_264568_((String)"cli.link.remove", (String)"x");
        MutableComponent parentClearHoverText = Component.m_264642_((String)"cli.msg.info.region.parent.clear.link.hover", (String)"Clear '%s' as parent region", (Object[])new Object[]{region.getParent().getName()});
        return ChatComponentBuilder.buildExecuteCmdComponent(parentClearLinkText, parentClearHoverText, clearRegionParentCmd, ClickEvent.Action.RUN_COMMAND, Messages.REMOVE_CMD_COLOR);
    }

    private static MutableComponent createParentAddLink(IProtectedRegion region) {
        String setRegionParentCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().m_135782_().toString(), region.getName(), CommandConstants.PARENT.toString(), CommandConstants.SET.toString(), "");
        MutableComponent setParentLinkText = Component.m_264568_((String)"cli.link.add", (String)"+");
        MutableComponent setParentHoverText = Component.m_264642_((String)"cli.msg.info.region.parent.set.link.hover", (String)"Set parent for region %s", (Object[])new Object[]{region.getName()});
        return Messages.substitutable("%s %s", Component.m_264568_((String)"cli.msg.info.region.parent.null", (String)"No parent set"), ChatComponentBuilder.buildExecuteCmdComponent(setParentLinkText, setParentHoverText, setRegionParentCmd, ClickEvent.Action.RUN_COMMAND, ChatFormatting.GREEN));
    }

    public static MutableComponent buildDimRegionsLink(LevelRegionData levelRegionData) {
        DimensionalRegion dimRegion = levelRegionData.getDim();
        String command = Commands.buildCommandStr(CommandConstants.DIM.toString(), dimRegion.getDim().m_135782_().toString(), CommandConstants.LIST.toString(), CommandConstants.LOCAL.toString());
        MutableComponent text = Component.m_264642_((String)"cli.msg.dim.info.region.list.link.text", (String)"%s region(s)", (Object[])new Object[]{levelRegionData.regionCount()});
        MutableComponent hover = Component.m_264642_((String)"cli.msg.dim.info.region.list.link.hover", (String)"List regions in %s", (Object[])new Object[]{dimRegion.getName()});
        MutableComponent listLocalRegionsLink = ChatComponentBuilder.buildExecuteCmdComponent(text, hover, command, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
        MutableComponent createRegionLink = ChatLinkBuilder.buildDimCreateRegionLink(dimRegion);
        if (dimRegion.getChildren().isEmpty()) {
            return Messages.substitutable("%s %s", text, createRegionLink);
        }
        return Messages.substitutable("%s %s", listLocalRegionsLink, createRegionLink);
    }

    public static MutableComponent buildRegionListChildrenLink(IProtectedRegion region) {
        MutableComponent text = Component.m_264642_((String)"cli.msg.info.region.children.list.link.text", (String)"%s child regions(s)", (Object[])new Object[]{region.getChildren().size()});
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.children.list.link.hover", (String)"List direct child regions of '%s'", (Object[])new Object[]{region.getName()});
        String command = Commands.buildListChildRegionCommand(region);
        return switch (region.getRegionType()) {
            case RegionType.GLOBAL -> {
                Set<String> dimensionList = RegionDataManager.getLevelNames();
                MutableComponent listDimRegionsLinkText = Component.m_264642_((String)"cli.msg.global.info.region.list.link.text", (String)"%s dimensions(s)", (Object[])new Object[]{dimensionList.size()});
                MutableComponent listDimRegionsHoverText = Component.m_264568_((String)"cli.msg.global.info.region.list.link.hover", (String)"List all Dimensional Regions");
                yield ChatComponentBuilder.buildExecuteCmdComponent(listDimRegionsLinkText, listDimRegionsHoverText, command, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
            }
            case RegionType.DIMENSION -> {
                MutableComponent listDimRegionsListLink = ChatComponentBuilder.buildExecuteCmdComponent(text, hover, command, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
                if (region.getChildren().isEmpty()) {
                    yield Messages.substitutable("%s %s", text, ChatLinkBuilder.buildDimCreateRegionLink(region));
                }
                yield Messages.substitutable("%s %s", listDimRegionsListLink, ChatLinkBuilder.buildDimCreateRegionLink(region));
            }
            case RegionType.LOCAL -> {
                MutableComponent regionChildrenLink = ChatComponentBuilder.buildExecuteCmdComponent(text, hover, command, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
                MutableComponent addChildrenLink = ChatLinkBuilder.buildRegionAddChildrenLink(region);
                if (region.getChildren().isEmpty()) {
                    yield Messages.substitutable("%s %s", text, addChildrenLink);
                }
                yield Messages.substitutable("%s %s", regionChildrenLink, addChildrenLink);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)region.getRegionType()));
        };
    }

    public static MutableComponent buildRegionAddChildrenLink(IProtectedRegion region) {
        String addChildrenCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().m_135782_().toString(), region.getName(), CommandConstants.ADD.toString(), CommandConstants.CHILD.toString(), "");
        MutableComponent addChildrenLinkText = Component.m_264568_((String)"cli.link.add", (String)"+");
        MutableComponent addChildrenHoverText = Component.m_264642_((String)"cli.msg.info.region.children.add.link.hover", (String)"Add child to region %s", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdComponent(addChildrenLinkText, addChildrenHoverText, addChildrenCmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.ADD_CMD_COLOR);
    }

    public static MutableComponent buildDimCreateRegionLink(IProtectedRegion region) {
        String dimCreateRegionCmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), region.getDim().m_135782_().toString(), CommandConstants.CREATE.toString(), CommandConstants.LOCAL.toString(), "");
        MutableComponent createRegionLinkText = Component.m_264568_((String)"cli.link.add", (String)"+");
        MutableComponent createRegionHoverText = Component.m_264642_((String)"cli.msg.dim.info.region.create.link.hover", (String)"Create region in dimension %s", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdComponent(createRegionLinkText, createRegionHoverText, dimCreateRegionCmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.ADD_CMD_COLOR);
    }

    public static MutableComponent buildResponsibleFlagListLink(IProtectedRegion region) {
        Map<String, FlagCorrelation> flagsInHierarchy = HandlerUtil.getFlagMapRecursive(region, null);
        MutableComponent responsibleFlagsNumber = ChatComponentBuilder.buildTextWithHoverMsg(Messages.substitutable("%s", flagsInHierarchy.size()), Component.m_264642_((String)"cli.msg.info.region.flag.responsible.number.hover", (String)"%s flag(s) applicable for %s", (Object[])new Object[]{flagsInHierarchy.size(), region.getName()}), Messages.LINK_COLOR);
        MutableComponent responsibleFlagListHoverText = Component.m_264642_((String)"cli.msg.info.region.flag.responsible.link.hover", (String)"Show responsible region flags for %s", (Object[])new Object[]{region.getName()});
        String flagListCmd = Commands.buildListFlagsCommand(region);
        MutableComponent responsibleFlagListLink = ChatComponentBuilder.buildExecuteCmdComponent(responsibleFlagsNumber, responsibleFlagListHoverText, flagListCmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
        MutableComponent responsibleFlagsComp = flagsInHierarchy.isEmpty() ? responsibleFlagsNumber : responsibleFlagListLink;
        return Component.m_264642_((String)"cli.msg.info.region.flag.responsible.link.text", (String)"%s responsible flag(s)", (Object[])new Object[]{responsibleFlagsComp});
    }

    public static MutableComponent buildRegionFlagListLink(IProtectedRegion region) {
        MutableComponent regionFlagNumber = ChatComponentBuilder.buildTextWithHoverMsg(Messages.substitutable("%s", region.getFlags().size()), Component.m_264642_((String)"cli.msg.info.region.flag.number.hover", (String)"%s flag(s) in %s", (Object[])new Object[]{region.getFlags().size(), region.getName()}), Messages.LINK_COLOR);
        MutableComponent flagListHoverText = Component.m_264642_((String)"cli.msg.info.region.flag.link.hover", (String)"%s flag(s) in %s", (Object[])new Object[]{region.getFlags().size(), region.getName()});
        String regionFlagListCmd = Commands.buildListRegionFlagsCommand(region);
        MutableComponent regionFlagListLink = ChatComponentBuilder.buildExecuteCmdComponent(regionFlagNumber, flagListHoverText, regionFlagListCmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
        MutableComponent regionFlagsComp = region.getFlags().isEmpty() ? regionFlagNumber : regionFlagListLink;
        return Messages.substitutable("%s %s", Component.m_264642_((String)"cli.msg.info.region.flag.region.link.text", (String)"%s flag(s)", (Object[])new Object[]{regionFlagsComp}), ChatLinkBuilder.buildSuggestAddFlagLink(region));
    }

    public static MutableComponent buildSuggestAddFlagLink(IProtectedRegion region) {
        return ChatLinkBuilder.buildAddFlagLink(region, "", ClickEvent.Action.SUGGEST_COMMAND);
    }

    public static MutableComponent buildAddFlagLink(IProtectedRegion region, String flag) {
        return ChatLinkBuilder.buildAddFlagLink(region, flag, ClickEvent.Action.RUN_COMMAND);
    }

    public static MutableComponent buildAddFlagLink(IProtectedRegion region, String flag, ClickEvent.Action action) {
        MutableComponent hoverText = Component.m_264642_((String)"cli.msg.info.region.flag.add.link.hover", (String)"Add new flag to region %s", (Object[])new Object[]{region.getName()});
        MutableComponent linkText = Component.m_264568_((String)"cli.link.add", (String)"+");
        String cmd = Commands.buildAddFlagCommand(region, flag);
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, action, Messages.ADD_CMD_COLOR);
    }

    public static MutableComponent buildDimensionalBlockTpLink(ResourceKey<Level> dim, BlockPos target) {
        String teleportCmd = ChatComponentBuilder.buildTeleportCmd(dim, "@s", target);
        MutableComponent text = Component.m_264642_((String)"cli.msg.info.region.area.tp.block.link.text", (String)"%s", (Object[])new Object[]{ChatComponentBuilder.buildBlockPosLinkText(target)});
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.area.tp.block.link.hover", (String)"Click to teleport to %s", (Object[])new Object[]{ChatComponentBuilder.shortBlockPosBracketed(target)});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, teleportCmd, ClickEvent.Action.RUN_COMMAND, Messages.TP_COLOR);
    }

    public static MutableComponent buildDimensionalBlockTpLink(ResourceKey<Level> dim, BlockPos target, MutableComponent text) {
        String teleportCmd = ChatComponentBuilder.buildTeleportCmd(dim, "@s", target);
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.area.tp.block.link.hover", (String)"Click to teleport to %s", (Object[])new Object[]{ChatComponentBuilder.shortBlockPosBracketed(target)});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, teleportCmd, ClickEvent.Action.RUN_COMMAND, Messages.TP_COLOR);
    }

    public static MutableComponent buildDimensionalBlockTpLink(ResourceKey<Level> dim, BlockPos target, MutableComponent text, MutableComponent hover) {
        String teleportCmd = ChatComponentBuilder.buildTeleportCmd(dim, "@s", target);
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, teleportCmd, ClickEvent.Action.RUN_COMMAND, Messages.TP_COLOR);
    }

    public static MutableComponent buildDimSuggestRegionRemovalLink(IMarkableRegion region) {
        String cmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), region.getDim().m_135782_().toString(), CommandConstants.DELETE.toString(), region.getName());
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.dim.region.remove.link.hover", (String)"Remove region %s", (Object[])new Object[]{region.getName()});
        MutableComponent text = Component.m_264568_((String)"cli.link.remove", (String)"x");
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.REMOVE_CMD_COLOR);
    }

    public static MutableComponent buildRegionRemoveChildLink(IProtectedRegion region, IProtectedRegion child) {
        String command = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().m_135782_().toString(), region.getName(), CommandConstants.REMOVE.toString(), CommandConstants.CHILD.toString(), child.getName());
        MutableComponent linkText = Component.m_264568_((String)"cli.link.remove", (String)"x");
        MutableComponent linkHoverText = Component.m_264642_((String)"cli.msg.info.region.children.remove.link.hover", (String)"Remove child '%s' from region %s", (Object[])new Object[]{child.getName(), region.getName()});
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, linkHoverText, command, ClickEvent.Action.SUGGEST_COMMAND, Messages.REMOVE_CMD_COLOR);
    }

    public static MutableComponent buildRegionActionUndoLink(String cmd, CommandConstants toReplace, CommandConstants replacement) {
        String revertCmd = ArgumentUtil.revertCommand(cmd, toReplace, replacement);
        MutableComponent revertLinkText = Component.m_264568_((String)"cli.link.action.undo.text", (String)"<-");
        MutableComponent revertLinkHover = Component.m_264568_((String)"cli.link.action.undo.hover", (String)"Undo action.");
        return ChatComponentBuilder.buildExecuteCmdComponent(revertLinkText, revertLinkHover, revertCmd, ClickEvent.Action.RUN_COMMAND, ChatFormatting.DARK_RED);
    }

    public static MutableComponent buildRegionActionUndoLink(String cmd, String toReplace, String replacement) {
        String revertCmd = ArgumentUtil.revertCommand(cmd, toReplace, replacement);
        MutableComponent revertLinkText = Component.m_264568_((String)"cli.link.action.undo.text", (String)"<-");
        MutableComponent revertLinkHover = Component.m_264568_((String)"cli.link.action.undo.hover", (String)"Undo action.");
        return ChatComponentBuilder.buildExecuteCmdComponent(revertLinkText, revertLinkHover, revertCmd, ClickEvent.Action.RUN_COMMAND, ChatFormatting.DARK_RED);
    }

    public static MutableComponent buildRemoveGroupMemberLink(IProtectedRegion region, String name, GroupType groupType, String group, MutableComponent linkText, MutableComponent hoverText) {
        String cmd = Commands.buildRemoveGroupMemberCommand(region, groupType, group, name);
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, Messages.REMOVE_CMD_COLOR);
    }

    public static MutableComponent buildRemoveLinkForOfflinePlayer(IProtectedRegion region, String name, GroupType groupType, String group, MutableComponent linkText, MutableComponent hoverText) {
        String cmd = Commands.buildRemoveOfflinePlayerCommand(region, group, groupType, name);
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, Messages.REMOVE_CMD_COLOR);
    }
}

