/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class VisualizationOptionsMessage
implements MultiLineMessage<IMarkableArea> {
    private final IMarkableRegion region;
    private final List<Component> infoLines;

    public VisualizationOptionsMessage(IMarkableRegion region) {
        this.region = region;
        this.infoLines = new ArrayList<Component>();
    }

    @Override
    public List<Component> getLines() {
        this.infoLines.clear();
        MutableComponent header = ChatComponentBuilder.buildHeader(Component.m_264642_((String)"cli.msg.info.header.of", (String)"== %s of %s ==", (Object[])new Object[]{ChatLinkBuilder.buildRegionVisualizationLink(this.region), ChatLinkBuilder.buildRegionInfoLink(this.region)}));
        MutableComponent showSubject = Component.m_264568_((String)"cli.msg.info.region.visualization.show", (String)"Show");
        MutableComponent hideSubject = Component.m_264568_((String)"cli.msg.info.region.visualization.hide", (String)"Hide");
        MutableComponent hierarchySubject = Component.m_264568_((String)"cli.msg.info.region.visualization.hierarchy", (String)"Hierarchy");
        MutableComponent intersectingSubject = Component.m_264568_((String)"cli.msg.info.region.visualization.intersecting", (String)"Intersecting");
        MutableComponent customShowLink = VisualizationOptionsMessage.buildShowAdvancedLink(this.region, DisplayType.FRAME, ResourceLocation.m_214293_((String)"minecraft", (String)"cyan_stained_glass"), true, 15);
        MutableComponent displayActions = ChatComponentBuilder.buildInfoComponent(showSubject, VisualizationOptionsMessage.buildShowLinks(this.region), customShowLink);
        MutableComponent hideActions = ChatComponentBuilder.buildInfoComponent(hideSubject, VisualizationOptionsMessage.buildHideLinks(this.region));
        MutableComponent hierarchy = ChatComponentBuilder.buildInfoComponent(hierarchySubject, VisualizationOptionsMessage.buildHierarchyShowLink(this.region), VisualizationOptionsMessage.buildHierarchyHideLink(this.region));
        MutableComponent intersecting = ChatComponentBuilder.buildInfoComponent(intersectingSubject, VisualizationOptionsMessage.buildIntersectingShowLink(this.region), VisualizationOptionsMessage.buildIntersectingHideLink(this.region));
        this.infoLines.add((Component)header);
        this.infoLines.add((Component)displayActions);
        this.infoLines.add((Component)hideActions);
        this.infoLines.add((Component)hierarchy);
        this.infoLines.add((Component)intersecting);
        return this.infoLines;
    }

    @Override
    public IMarkableArea getContent() {
        return this.region.getArea();
    }

    public static MutableComponent buildShowLinks(IMarkableRegion region) {
        MutableComponent frameLink = VisualizationOptionsMessage.buildShowLink(region, DisplayType.FRAME);
        MutableComponent hullLink = VisualizationOptionsMessage.buildShowLink(region, DisplayType.HULL);
        MutableComponent minimalLink = VisualizationOptionsMessage.buildShowLink(region, DisplayType.MINIMAL);
        MutableComponent markedLink = VisualizationOptionsMessage.buildShowLink(region, DisplayType.MARKED);
        return Messages.substitutable("%s %s %s %s", frameLink, hullLink, minimalLink, markedLink);
    }

    public static MutableComponent buildShowAdvancedLink(IMarkableRegion region, DisplayType displayType, ResourceLocation block, boolean glow, int lightLevel) {
        String cmd = Commands.buildAdvancedVisualizationShowCommand(region, displayType, block, glow, lightLevel);
        MutableComponent text = Component.m_264568_((String)"cli.msg.info.region.visualization.show.advanced.link.text", (String)"custom");
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.visualization.show.advanced.link.hover", (String)"Click to paste custom visualization command for '%s'", (Object[])new Object[]{displayType.name, region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, cmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildHideLinks(IMarkableRegion region) {
        MutableComponent frameLink = VisualizationOptionsMessage.buildHideLink(region, DisplayType.FRAME);
        MutableComponent hullLink = VisualizationOptionsMessage.buildHideLink(region, DisplayType.HULL);
        MutableComponent minimalLink = VisualizationOptionsMessage.buildHideLink(region, DisplayType.MINIMAL);
        MutableComponent markedLink = VisualizationOptionsMessage.buildHideLink(region, DisplayType.MARKED);
        return Messages.substitutable("%s %s %s %s", frameLink, hullLink, minimalLink, markedLink);
    }

    public static MutableComponent buildShowLink(IMarkableRegion region, DisplayType displayType) {
        MutableComponent text = Component.m_264642_((String)"cli.msg.info.region.visualization.show.link.text", (String)"%s", (Object[])new Object[]{displayType.name});
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.visualization.show.link.hover", (String)"Click to show %s-Visualization for '%s'", (Object[])new Object[]{displayType.name, region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildVisualizationShowCommand(region, displayType), ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildHideLink(IMarkableRegion region, DisplayType displayType) {
        MutableComponent text = Component.m_264642_((String)"cli.msg.info.region.visualization.hide.link.text", (String)"%s", (Object[])new Object[]{displayType.name});
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.visualization.hide.link.hover", (String)"Click to hide %s-Visualization for '%s'", (Object[])new Object[]{displayType.name, region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildVisualizationHideCommand(region, displayType), ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildHierarchyShowLink(IMarkableRegion region) {
        MutableComponent text = Component.m_264568_((String)"cli.msg.info.region.visualization.hierarchy.show.link.text", (String)"Show");
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.visualization.hierarchy.show.link.hover", (String)"Click to show visualization for all child regions of '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildVisualizationShowHierarchyCommand(region), ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildHierarchyHideLink(IMarkableRegion region) {
        MutableComponent text = Component.m_264568_((String)"cli.msg.info.region.visualization.hierarchy.hide.link.text", (String)"Hide");
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.visualization.hierarchy.hide.link.hover", (String)"Click to hide visualization for all child regions of '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildVisualizationHideHierarchyCommand(region), ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildIntersectingHideLink(IMarkableRegion region) {
        MutableComponent text = Component.m_264568_((String)"cli.msg.info.region.visualization.intersecting.hide.link.text", (String)"Hide");
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.visualization.intersecting.hide.link.hover", (String)"Click to hide visualization of intersecting regions for '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildVisualizationHideIntersectingCommand(region), ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildIntersectingShowLink(IMarkableRegion region) {
        MutableComponent text = Component.m_264568_((String)"cli.msg.info.region.visualization.intersecting.show.link.text", (String)"Show");
        MutableComponent hover = Component.m_264642_((String)"cli.msg.info.region.visualization.intersecting.show.link.hover", (String)"Click to show visualization of intersecting regions for '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildVisualizationShowIntersectingCommand(region), ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }
}

