/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.pagination.BasePaginationMessage;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import java.util.List;
import net.minecraft.network.chat.Component;

public class RegionsInDimensionPagination
extends BasePaginationMessage<IProtectedRegion> {
    private final IProtectedRegion region;
    private final LevelRegionData levelData;

    public RegionsInDimensionPagination(LevelRegionData levelData, List<IProtectedRegion> entries, int pageNumber, int pageSize) throws InvalidPageNumberException {
        super(entries, Commands.buildListLocalRegionCommand(levelData.getId()), pageNumber, pageSize);
        this.region = levelData.getDim();
        this.levelData = levelData;
    }

    @Override
    public List<Component> buildEntries() {
        return ChatComponentBuilder.buildRemoveRegionEntries(this.region, this.pageContent);
    }

    @Override
    public Component noContentMsg() {
        return Component.m_264642_((String)"cli.msg.dim.info.regions.empty", (String)"No regions defined in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(this.levelData.getDim())});
    }

    @Override
    public Component header() {
        return ChatComponentBuilder.buildHeader(Component.m_264642_((String)"cli.msg.info.header.in", (String)"== %s in %s ==", (Object[])new Object[]{ChatLinkBuilder.buildDimRegionsLink(this.levelData), ChatLinkBuilder.buildRegionInfoLink(this.levelData.getDim())}));
    }

    @Override
    public Component emptyEntry() {
        return Messages.substitutable(" - %s", ChatLinkBuilder.buildDimCreateRegionLink(this.levelData.getDim()));
    }
}

