package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.core.flag.FlagCorrelation;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

import static de.z0rdak.yawp.api.commands.CommandConstants.FLAG;
import static de.z0rdak.yawp.api.commands.CommandConstants.REMOVE;
import static de.z0rdak.yawp.api.commands.Commands.buildCommandStr;
import static de.z0rdak.yawp.api.commands.Commands.buildListFlagsCommand;
import static de.z0rdak.yawp.handler.HandlerUtil.getFlagMapRecursive;
import static de.z0rdak.yawp.util.ChatComponentBuilder.buildExecuteCmdComponent;
import static de.z0rdak.yawp.util.ChatComponentBuilder.buildHeader;
import static de.z0rdak.yawp.util.text.Messages.REMOVE_CMD_COLOR;
import static de.z0rdak.yawp.util.text.messages.pagination.RegionFlagPagination.buildFlagQuickActionComponent;
import static net.minecraft.class_124.*;
import static net.minecraft.class_2558.class_2559.field_11750;

public class ResponsibleFlagPagination extends BasePaginationMessage<FlagCorrelation> {

    private final IProtectedRegion region;

    public ResponsibleFlagPagination(IProtectedRegion region, int pageNumber, int pageSize) throws InvalidPageNumberException {
        super(getCorrelations(region), buildListFlagsCommand(region), pageNumber, pageSize);
        this.region = region;
    }

    public static class_5250 buildRegionFlagInfoHeader(IProtectedRegion region, class_5250 flagListLink) {
        return buildHeader(class_2561.method_48322("cli.msg.info.header.in", "== %s in %s ==", flagListLink, ChatLinkBuilder.buildRegionInfoLink(region)));
    }

    public static List<class_2561> buildRegionFlagEntries(IProtectedRegion region) {
        return buildRegionFlagEntries(region, region.getFlags().flags().stream().toList());
    }

    public static List<class_2561> buildRegionFlagEntries(IProtectedRegion region, List<IFlag> selectedFlags) {
        List<class_2561> flagEntries = new ArrayList<>();
        flagEntries.addAll(buildFlagEntriesForState(region, selectedFlags, FlagState.DENIED));
        flagEntries.addAll(buildFlagEntriesForState(region, selectedFlags, FlagState.ALLOWED));
        flagEntries.addAll(buildFlagEntriesForState(region, selectedFlags, FlagState.DISABLED));
        return flagEntries;
    }

    public static List<class_5250> buildFlagEntriesForState(IProtectedRegion region, List<IFlag> selectedFlags, FlagState state) {
        List<IFlag> flagsByState = selectedFlags.stream()
                .filter(f -> f.getState() == state)
                .sorted(Comparator.comparing(IFlag::getName))
                .toList();
        return flagsByState.stream()
                .map(flag -> buildRemoveFlagEntry(region, flag, colorForState(flag.getState())))
                .collect(Collectors.toList());
    }

    /**
     * Creates a TextComponent for flag removal, followed by the flag infos
     */
    public static class_5250 buildRemoveFlagEntry(IProtectedRegion region, IFlag flag, class_124 flagLinkColor, class_124... ChatFormattings) {
        // [x] [flagname] [<region-indicator] [] []
        String cmd;
        switch (region.getRegionType()) {
            case GLOBAL: {
                cmd = buildCommandStr(CommandConstants.GLOBAL.toString(), REMOVE.toString(), FLAG.toString(), flag.getName());
                break;
            }
            case DIMENSION: {
                cmd = buildCommandStr(CommandConstants.DIM.toString(), region.getDim().method_29177().toString(), REMOVE.toString(), FLAG.toString(), flag.getName());
                break;
            }
            case LOCAL: {
                cmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), REMOVE.toString(), FLAG.toString(), flag.getName());
                break;
            }
            default:
                throw new IllegalArgumentException();
        }
        class_5250 hoverText = class_2561.method_48322("cli.msg.info.region.flag.remove.link.hover", "Remove flag '%s' from region %s", flag.getName(), region.getName());
        class_5250 linkText = class_2561.method_48321("cli.link.remove", "x");
        class_5250 flagRemoveLink = buildExecuteCmdComponent(linkText, hoverText, cmd, field_11750, REMOVE_CMD_COLOR);
        class_5250 flagQuickActionComponent = buildFlagQuickActionComponent(region, flag, flagLinkColor);
        flagQuickActionComponent.method_27695(ChatFormattings);
        return Messages.substitutable(" - %s %s", flagRemoveLink, flagQuickActionComponent);
    }

    public static class_124 colorForState(FlagState state) {
        switch (state) {
            case ALLOWED:
                return field_1060;
            case DENIED:
                return field_1061;
            case DISABLED:
                return field_1080;
            default:
                throw new IllegalArgumentException();
        }
    }

    /**
     * Show flags for region, with a color of their state
     * But also show parent flags in italic
     * How do we want to handle flags defined in the region but also in the parent?
     * If the child flag is dominant, we display the child flag, and add a hint to the parent
     * If the flag is overriden, we format them with strikethrough and add a link to the parent which overrides it
     */
    public static List<class_5250> buildFlagEntries(IProtectedRegion region) {
        List<class_5250> flagEntries = new ArrayList<>();
        Map<String, FlagCorrelation> flagMapRecursive = getFlagMapRecursive(region, null);
        Map<FlagState, List<FlagCorrelation>> flagStateListMap = sortFlagsByState(flagMapRecursive);
        flagEntries.addAll(buildFlagEntries(flagStateListMap, FlagState.ALLOWED));
        flagEntries.addAll(buildFlagEntries(flagStateListMap, FlagState.DENIED));
        flagEntries.addAll(buildFlagEntries(flagStateListMap, FlagState.DISABLED));
        return flagEntries;
    }

    public static List<class_2561> buildFlagEntries(List<FlagCorrelation> flags) {
        return flags.stream()
                .map(fc -> buildRemoveFlagEntry(fc.region(), fc.flag(), colorForState(fc.flag().getState())))
                .collect(Collectors.toList());
    }

    public static List<class_5250> buildFlagEntries(Map<FlagState, List<FlagCorrelation>> flagStateListMap, FlagState state) {
        List<FlagCorrelation> flagsByState = flagStateListMap.get(state);
        flagsByState.sort(Comparator.comparing(flagCorrelation -> flagCorrelation.flag().getName()));
        return flagsByState.stream()
                .map(flagCorrelation -> buildRemoveFlagEntry(flagCorrelation.region(), flagCorrelation.flag(), colorForState(state)))
                .collect(Collectors.toList());
    }

    public static Map<FlagState, List<IFlag>> sortFlagsByState(IProtectedRegion region) {
        HashMap<FlagState, List<IFlag>> flagStateListMap = new HashMap<>();
        flagStateListMap.put(FlagState.DENIED, region.getFlags().flags(FlagState.DENIED));
        flagStateListMap.put(FlagState.ALLOWED, region.getFlags().flags(FlagState.ALLOWED));
        flagStateListMap.put(FlagState.DISABLED, region.getFlags().flags(FlagState.DISABLED));
        return flagStateListMap;
    }

    public static Map<FlagState, List<FlagCorrelation>> sortFlagsByState(Map<String, FlagCorrelation> flagMap) {
        HashMap<FlagState, List<FlagCorrelation>> flagStateListMap = new HashMap<>();
        flagStateListMap.put(FlagState.DENIED, getCorrelationByState(flagMap, FlagState.DENIED));
        flagStateListMap.put(FlagState.ALLOWED, getCorrelationByState(flagMap, FlagState.ALLOWED));
        flagStateListMap.put(FlagState.DISABLED, getCorrelationByState(flagMap, FlagState.DISABLED));
        return flagStateListMap;
    }

    public static List<FlagCorrelation> getCorrelations(IProtectedRegion region) {
        Map<String, FlagCorrelation> flagMap = getFlagMapRecursive(region, null);
        return flagMap.values().stream()
                .filter(c -> c.flag() != null)
                .sorted(Comparator.comparing(c -> c.flag().getState()))
                .sorted(Comparator.comparing(c -> c.flag().getName()))
                .collect(Collectors.toList());
    }

    private static List<FlagCorrelation> getCorrelationByState(Map<String, FlagCorrelation> flagMap, FlagState state) {
        return flagMap.values().stream()
                .filter(c -> c.flag() != null) // TODO: ??
                .filter(c -> c.flag().getState() == state)
                .sorted(Comparator.comparing(c -> c.flag().getName()))
                .collect(Collectors.toList());
    }

    @Override
    public class_2561 noContentMsg() {
        return class_2561.method_48322("cli.msg.info.region.flag.empty", "No flags defined in %s", ChatLinkBuilder.buildRegionInfoLink(region));
    }

    @Override
    public class_2561 header() {
        return buildRegionFlagInfoHeader(this.region, ChatLinkBuilder.buildRegionFlagListLink(this.region));
    }

    @Override
    public List<class_2561> buildEntries() {
        return buildFlagEntries(this.pageContent);
    }

    @Override
    public class_2561 emptyEntry() {
        return Messages.substitutable(" - %s", ChatLinkBuilder.buildSuggestAddFlagLink(region));
    }


}
