/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.core.region;

import de.z0rdak.yawp.api.core.region.LocalRegionBuilder;
import de.z0rdak.yawp.core.area.SphereArea;
import de.z0rdak.yawp.core.region.SphereRegion;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class SphereRegionBuilder
extends LocalRegionBuilder<SphereRegion> {
    private SphereArea sphereArea;

    public SphereRegionBuilder(String name) {
        super(name);
    }

    public SphereRegionBuilder setArea(SphereArea area) {
        this.sphereArea = area;
        return this;
    }

    @Override
    public SphereRegion build() {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("Region name cannot be null or empty");
        }
        if (this.sphereArea == null) {
            throw new IllegalArgumentException("Cuboid area cannot be null");
        }
        if (this.dim == null) {
            throw new IllegalArgumentException("Dimension cannot be null");
        }
        SphereRegion region = new SphereRegion(this.name, this.sphereArea, (ResourceKey<Level>)this.dim);
        region.setPriority(this.priority);
        region.setIsActive(this.active);
        region.setIsMuted(this.muted);
        region.setGroups(this.groups);
        region.setFlags(this.flags);
        return region;
    }
}

