/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.data.region;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.region.GlobalRegion;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalRegionData
extends SavedData {
    public static final String GLOBAL_REGION_FILE_NAME = "global";
    public static final String TYPE = "yawp/global";
    public static final Codec<GlobalRegionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(r -> GlobalRegion.GLOBAL), (App)GlobalRegion.CODEC.optionalFieldOf(GLOBAL_REGION_FILE_NAME, (Object)new GlobalRegion()).forGetter(GlobalRegionData::getGlobal)).apply((Applicative)instance, GlobalRegionData::new));
    private final ResourceLocation id;
    private GlobalRegion globalRegion;

    public GlobalRegionData() {
        this.id = GlobalRegion.GLOBAL;
        this.globalRegion = new GlobalRegion();
    }

    public GlobalRegionData(ResourceLocation id, GlobalRegion region) {
        this.id = id;
        this.globalRegion = region;
    }

    public static GlobalRegionData load(CompoundTag tag, HolderLookup.Provider provider) {
        return CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(arg_0 -> ((Logger)Constants.LOGGER).warn(arg_0)).orElse(new GlobalRegionData());
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        Optional nbt = CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).resultOrPartial(arg_0 -> ((Logger)Constants.LOGGER).warn(arg_0));
        if (nbt.isPresent()) {
            tag = (CompoundTag)nbt.get();
        }
        return tag;
    }

    public GlobalRegion getGlobal() {
        return this.globalRegion;
    }

    public void reset() {
        this.globalRegion = new GlobalRegion();
    }

    public static GlobalRegionData get(DimensionDataStorage dataStorage, @Nullable Supplier<GlobalRegionData> globalRegionDataSupplier) {
        Supplier<GlobalRegionData> supplier = globalRegionDataSupplier != null ? globalRegionDataSupplier : GlobalRegionData::new;
        SavedData.Factory factory = new SavedData.Factory(supplier, GlobalRegionData::load, DataFixTypes.SAVED_DATA_MAP_DATA);
        return (GlobalRegionData)dataStorage.computeIfAbsent(factory, TYPE);
    }
}

