/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.platform;

import de.z0rdak.yawp.api.events.region.ForgeFlagCheckEvent;
import de.z0rdak.yawp.api.events.region.ForgeFlagCheckResult;
import de.z0rdak.yawp.config.ConfigRegistry;
import de.z0rdak.yawp.config.server.FlagConfig;
import de.z0rdak.yawp.config.server.LoggingConfig;
import de.z0rdak.yawp.config.server.PermissionConfig;
import de.z0rdak.yawp.config.server.RegionConfig;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.platform.services.IConfigHelper;
import fuzs.forgeconfigapiport.forge.api.neoforge.v4.NeoForgeConfigRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ForgeConfigHelper
implements IConfigHelper {
    @Override
    public void registerServerConfig(ModConfigSpec spec, String configName) {
        this.registerModConfig(spec, ModConfig.Type.SERVER, configName);
    }

    @Override
    public void registerClientConfig(ModConfigSpec spec, String configName) {
        this.registerModConfig(spec, ModConfig.Type.CLIENT, configName);
    }

    @Override
    public void registerCommonConfig(ModConfigSpec spec, String configName) {
        this.registerModConfig(spec, ModConfig.Type.COMMON, configName);
    }

    private void registerModConfig(ModConfigSpec spec, ModConfig.Type type, String configName) {
        NeoForgeConfigRegistry.INSTANCE.register("yawp", type, (IConfigSpec)spec, configName);
    }

    @Override
    public void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeConfigHelper::onConfigLoading);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeConfigHelper::onConfigReloading);
        Services.CONFIG_REGISTRY.registerServerConfig(PermissionConfig.CONFIG_SPEC, "yawp-common.toml");
        Services.CONFIG_REGISTRY.registerServerConfig(FlagConfig.CONFIG_SPEC, "yawp-flags.toml");
        Services.CONFIG_REGISTRY.registerServerConfig(RegionConfig.CONFIG_SPEC, "yawp-region-defaults.toml");
        Services.CONFIG_REGISTRY.registerServerConfig(LoggingConfig.CONFIG_SPEC, "yawp-logging.toml");
    }

    @SubscribeEvent
    public static void onConfigLoading(ModConfigEvent.Loading event) {
        if (event.getConfig().getModId().equals("yawp")) {
            Runnable registerHandler = () -> {
                if (LoggingConfig.shouldLogFlagChecks()) {
                    MinecraftForge.EVENT_BUS.addListener(e -> LoggingConfig.logCheck(ForgeFlagCheckEvent.asNonEvent(e)));
                }
                if (LoggingConfig.shouldLogFlagCheckResults()) {
                    MinecraftForge.EVENT_BUS.addListener(e -> LoggingConfig.logResult(ForgeFlagCheckResult.asNonEvent(e)));
                }
            };
            ConfigRegistry.onModLoaded(event.getConfig().getFileName(), registerHandler);
        }
    }

    @SubscribeEvent
    public static void onConfigReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getModId().equals("yawp")) {
            ConfigRegistry.onModReloaded(event.getConfig().getFileName(), () -> {});
        }
    }
}

