/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.flag;

import java.util.Arrays;
import java.util.List;

public enum FlagCategory {
    PLAYER("player"),
    BENEFICIAL("beneficial"),
    PLAYER_PREVENTION("prevention"),
    BLOCK("block"),
    ENTITY("entity"),
    ENVIRONMENT("environment"),
    PROTECTION("protection");

    public final String name;

    private FlagCategory(String name) {
        this.name = name;
    }

    public static FlagCategory from(String category) throws IllegalArgumentException {
        List<FlagCategory> categories = Arrays.stream(FlagCategory.values()).filter(flag -> flag.name.equalsIgnoreCase(category)).toList();
        if (categories.isEmpty()) {
            throw new IllegalArgumentException("Invalid flag category supplied");
        }
        return categories.get(0);
    }
}

