/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.data.region;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class LevelListData
extends SavedData {
    public static final String DIMENSIONS_FILE_NAME = "dimensions";
    public static Codec<LevelListData> LEVEL_LIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("dims", new ArrayList()).forGetter(LevelListData::getLevels)).apply((Applicative)instance, LevelListData::new));
    public static final SavedDataType<LevelListData> TYPE = new SavedDataType(String.join((CharSequence)"/", "yawp", "dimensions"), ctx -> new LevelListData(), ctx -> LEVEL_LIST_CODEC, null);
    private final Set<ResourceLocation> dimensions;

    public LevelListData(List<ResourceLocation> dims) {
        this.dimensions = new HashSet<ResourceLocation>(dims);
    }

    public LevelListData() {
        this.dimensions = new HashSet<ResourceLocation>();
    }

    public List<ResourceLocation> getLevels() {
        return new ArrayList<ResourceLocation>(this.dimensions);
    }

    public void addDimEntry(ResourceLocation rl) {
        this.dimensions.add(rl);
    }

    public boolean hasDimEntry(ResourceLocation rl) {
        return this.dimensions.contains(rl);
    }
}

