/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.multiline;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.GlobalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.MarkedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import de.z0rdak.yawp.util.text.messages.multiline.RegionStateMessage;
import de.z0rdak.yawp.util.text.messages.pagination.TeleportAnchorPagination;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class RegionInfoMessage
implements MultiLineMessage<IProtectedRegion> {
    private final IProtectedRegion region;
    private final List<Component> regionInfoLines;
    private static final int MAX_ENCODER_LIMIT = 30000;

    public RegionInfoMessage(IProtectedRegion region) {
        this.region = region;
        this.regionInfoLines = new ArrayList<Component>();
    }

    private static Optional<JsonObject> regionJson(IProtectedRegion region) {
        switch (region.getRegionType()) {
            case GLOBAL: {
                GlobalRegion global = (GlobalRegion)region;
                JsonObject json = new JsonObject();
                DataResult jsonResult = GlobalRegion.CODEC.encode((Object)global, (DynamicOps)JsonOps.INSTANCE, (Object)json);
                if (jsonResult.isSuccess()) {
                    JsonElement orThrow = (JsonElement)jsonResult.getOrThrow();
                    return Optional.ofNullable(orThrow.getAsJsonObject());
                }
                return Optional.of(json);
            }
            case DIMENSION: {
                DimensionalRegion dim = (DimensionalRegion)region;
                JsonObject json = new JsonObject();
                DataResult jsonResult = DimensionalRegion.CODEC.encode((Object)dim, (DynamicOps)JsonOps.INSTANCE, (Object)json);
                if (jsonResult.isSuccess()) {
                    JsonElement orThrow = (JsonElement)jsonResult.getOrThrow();
                    return Optional.ofNullable(orThrow.getAsJsonObject());
                }
                return Optional.of(json);
            }
            case LOCAL: {
                MarkedRegion local = (MarkedRegion)region;
                JsonObject json = new JsonObject();
                DataResult jsonResult = MarkedRegion.CODEC.encode((Object)local, (DynamicOps)JsonOps.INSTANCE, (Object)json);
                if (jsonResult.isSuccess()) {
                    JsonElement orThrow = (JsonElement)jsonResult.getOrThrow();
                    return Optional.ofNullable(orThrow.getAsJsonObject());
                }
                return Optional.of(json);
            }
        }
        return Optional.empty();
    }

    public static MutableComponent buildRegionOverviewHeader(IProtectedRegion region) {
        Optional<JsonObject> jsonObject = RegionInfoMessage.regionJson(region);
        String clipBoardText = "";
        if (jsonObject.isPresent()) {
            JsonObject regionJson = jsonObject.get();
            String jsonStr = regionJson.toString();
            clipBoardText = jsonStr.getBytes(StandardCharsets.UTF_8).length > 30000 ? "Region data to big to send to client, sorry" : regionJson.toString();
        }
        switch (region.getRegionType()) {
            case GLOBAL: {
                GlobalRegion global = (GlobalRegion)region;
                JsonObject json = new JsonObject();
                DataResult jsonResult = GlobalRegion.CODEC.encode((Object)global, (DynamicOps)JsonOps.INSTANCE, (Object)json);
                if (jsonResult.isSuccess()) {
                    JsonElement orThrow = (JsonElement)jsonResult.getOrThrow();
                    int length = orThrow.toString().getBytes(StandardCharsets.UTF_8).length;
                    MutableComponent dumpLinkText = Component.translatableWithFallback((String)"cli.msg.global.overview.header.dump.link.text", (String)"Global overview");
                    MutableComponent dumpLinkHover = Component.translatableWithFallback((String)"cli.msg.global.overview.header.dump.link.hover", (String)"Copy Global Region NBT to clipboard");
                    MutableComponent clipBoardDumpLink = ChatComponentBuilder.buildExecuteCmdComponent(dumpLinkText, dumpLinkHover, clipBoardText, ClickEvent.Action.COPY_TO_CLIPBOARD, ChatFormatting.GOLD);
                    return ChatComponentBuilder.buildHeader(Component.translatableWithFallback((String)"cli.msg.info.header.for", (String)"== %s for %s ==", (Object[])new Object[]{clipBoardDumpLink, ChatLinkBuilder.buildRegionInfoLink(region)}));
                }
            }
            case DIMENSION: {
                MutableComponent dumpLinkText = Component.translatableWithFallback((String)"cli.msg.dim.overview.header.dump.link.text", (String)"Dimension overview");
                MutableComponent dumpLinkHover = Component.translatableWithFallback((String)"cli.msg.dim.overview.header.dump.link.hover", (String)"Copy Dimensional Region NBT to clipboard");
                MutableComponent clipBoardDumpLink = ChatComponentBuilder.buildExecuteCmdComponent(dumpLinkText, dumpLinkHover, clipBoardText, ClickEvent.Action.COPY_TO_CLIPBOARD, ChatFormatting.GOLD);
                return ChatComponentBuilder.buildHeader(Component.translatableWithFallback((String)"cli.msg.info.header.for", (String)"== %s for %s ==", (Object[])new Object[]{clipBoardDumpLink, ChatLinkBuilder.buildRegionInfoLink(region)}));
            }
            case LOCAL: {
                MutableComponent dumpLinkText = Component.translatableWithFallback((String)"cli.msg.local.overview.header.dump.link.text", (String)"Region overview");
                MutableComponent dumpLinkHover = Component.translatableWithFallback((String)"cli.msg.local.overview.header.dump.link.hover", (String)"Copy Local Region NBT to clipboard");
                MutableComponent clipBoardDumpLink = ChatComponentBuilder.buildExecuteCmdComponent(dumpLinkText, dumpLinkHover, clipBoardText, ClickEvent.Action.COPY_TO_CLIPBOARD, ChatFormatting.GOLD);
                return ChatComponentBuilder.buildHeader(Component.translatableWithFallback((String)"cli.msg.info.header.for", (String)"== %s for %s ==", (Object[])new Object[]{clipBoardDumpLink, ChatLinkBuilder.buildRegionInfoLink(region)}));
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)region.getRegionType()));
    }

    public static MutableComponent buildFlagsListLink(IProtectedRegion region) {
        if (region.getRegionType() == RegionType.GLOBAL) {
            return ChatLinkBuilder.buildRegionFlagListLink(region);
        }
        return Messages.substitutable("%s | %s", ChatLinkBuilder.buildResponsibleFlagListLink(region), ChatLinkBuilder.buildRegionFlagListLink(region));
    }

    public static MutableComponent buildGroupLinks(IProtectedRegion region) {
        return ChatComponentBuilder.getGroupsForRegion(region).stream().map(group -> ChatLinkBuilder.buildGroupLink(region, group, ChatComponentBuilder.getGroupSize(region, group))).reduce(Component.literal((String)""), (link1, link2) -> link1.append(" ").append((Component)link2));
    }

    private static MutableComponent buildRegionHierarchyComponent(IProtectedRegion region) {
        MutableComponent listChildrenLink = ChatLinkBuilder.buildRegionListChildrenLink(region);
        switch (region.getRegionType()) {
            case GLOBAL: {
                return ChatComponentBuilder.buildInfoComponent("cli.msg.info.dimensions", "Dimensions", listChildrenLink);
            }
            case DIMENSION: {
                MutableComponent globalRegionLink = ChatLinkBuilder.buildRegionInfoLink(region.getParent(), Component.translatableWithFallback((String)"cli.msg.info.region.global.link.hover", (String)"Show global region info"));
                LevelRegionData levelData = RegionDataManager.getOrCreate(region.getDim());
                MutableComponent hierarchyLinks = Messages.substitutable("%s, %s, %s", globalRegionLink, ChatLinkBuilder.buildDimRegionsLink(levelData), listChildrenLink);
                return ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.hierarchy", "Hierarchy", hierarchyLinks);
            }
            case LOCAL: {
                MutableComponent parentRemoveThisChildLink = ChatLinkBuilder.buildRegionRemoveChildLink(region.getParent(), region);
                MutableComponent hierarchyLinks = Component.literal((String)"");
                if (region.getParent().getRegionType() == RegionType.DIMENSION) {
                    hierarchyLinks = Messages.substitutable("%s, %s", ChatLinkBuilder.buildRegionInfoLink(region.getParent()), listChildrenLink);
                }
                if (region.getParent().getRegionType() == RegionType.LOCAL) {
                    hierarchyLinks = Messages.substitutable("%s %s, %s", ChatLinkBuilder.buildRegionInfoLink(region.getParent()), parentRemoveThisChildLink, listChildrenLink);
                }
                return ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.parent", "Parent", hierarchyLinks);
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)region.getRegionType()));
    }

    @Override
    public IProtectedRegion getContent() {
        return this.region;
    }

    @Override
    public List<Component> getLines() {
        MutableComponent header = RegionInfoMessage.buildRegionOverviewHeader(this.region);
        this.regionInfoLines.add((Component)header);
        MutableComponent flagsText = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.flag", "Flags", RegionInfoMessage.buildFlagsListLink(this.region));
        this.regionInfoLines.add((Component)flagsText);
        if (this.region.getRegionType() == RegionType.LOCAL) {
            IMarkableRegion local = (IMarkableRegion)this.region;
            MutableComponent areaText = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.area", "Area", ChatLinkBuilder.buildRegionAreaLink(local));
            this.regionInfoLines.add((Component)areaText);
            MutableComponent subject = Component.translatableWithFallback((String)"cli.msg.info.region.visualization", (String)"Visualization");
            MutableComponent actions = Messages.substitutable("%s | %s", ChatLinkBuilder.buildRegionVisualizationLink(local), ChatLinkBuilder.buildDisplaySettingsLink(local));
            MutableComponent visualization = ChatComponentBuilder.buildInfoComponent(subject, actions);
            this.regionInfoLines.add((Component)visualization);
            MutableComponent tpAnchorSubject = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor", (String)"Teleport Anchors");
            MutableComponent tpAnchor = ChatComponentBuilder.buildInfoComponent(tpAnchorSubject, TeleportAnchorPagination.buildRegionTeleportAnchorListLink(local));
            this.regionInfoLines.add((Component)tpAnchor);
        }
        MutableComponent groupsText = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.group", "Groups", RegionInfoMessage.buildGroupLinks(this.region));
        this.regionInfoLines.add((Component)groupsText);
        MutableComponent hierarchy = RegionInfoMessage.buildRegionHierarchyComponent(this.region);
        this.regionInfoLines.add((Component)hierarchy);
        MutableComponent state = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state", "State", RegionStateMessage.buildRegionStateLink(this.region));
        this.regionInfoLines.add((Component)state);
        return this.regionInfoLines;
    }
}

