/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.visualization;

import de.z0rdak.yawp.api.visualization.VisualizationUtil;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class RegionVisualization {
    private final Map<BlockPos, Entity> displayEntities = new HashMap<BlockPos, Entity>();
    private BlockDisplayProperties properties;

    public BlockDisplayProperties getProperties() {
        return this.properties;
    }

    public RegionVisualization(BlockDisplayProperties properties) {
        this.properties = properties;
    }

    public boolean doesTrackEntityAt(BlockPos pos) {
        return this.displayEntities.containsKey(pos);
    }

    public void trackBlockDisplay(BlockPos pos, Entity entity) {
        this.displayEntities.put(pos, entity);
    }

    public void updateDisplay(BlockDisplayProperties displayProperties, boolean refresh) {
        this.properties = displayProperties;
        if (refresh) {
            this.refresh(displayProperties);
        }
    }

    private void refresh(BlockDisplayProperties properties) {
        this.displayEntities.forEach((pos, entity) -> VisualizationUtil.updateDisplayProperties(entity, properties));
    }

    public boolean hasEntitiesTracked() {
        return !this.displayEntities.isEmpty();
    }

    public void discardEntities() {
        this.displayEntities.forEach((pos, entity) -> entity.remove(Entity.RemovalReason.DISCARDED));
        this.displayEntities.clear();
    }

    public void updateBlock(ResourceLocation block) {
        this.properties.setBlockRl(block);
        this.displayEntities.forEach((pos, entity) -> VisualizationUtil.updateDisplayBlock(entity, block));
    }

    public void updateGlow(boolean glow) {
        this.properties.setHasGlow(glow);
        this.displayEntities.forEach((pos, entity) -> VisualizationUtil.updateDisplayGlow(entity, glow));
    }

    public void updateLightLevel(int lightLevel) {
        this.properties.setLightLevel(lightLevel);
        this.displayEntities.forEach((pos, entity) -> VisualizationUtil.updateDisplayLightLevel(entity, lightLevel));
    }
}

