/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api;

import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.api.events.region.FlagCheckResult;
import de.z0rdak.yawp.core.flag.FlagContext;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.GlobalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public record FlagEvaluator(FlagCheckResult result) {
    public FlagState state() {
        return this.result.getFlagState();
    }

    public FlagEvaluator onAllow(Consumer<FlagCheckResult> action) {
        if (this.state() == FlagState.ALLOWED && action != null) {
            action.accept(this.result);
        }
        return this;
    }

    public FlagEvaluator onDeny(Consumer<FlagCheckResult> action) {
        if (this.state() == FlagState.DENIED && action != null) {
            action.accept(this.result);
        }
        return this;
    }

    public FlagEvaluator onDenyWithMsg(Consumer<FlagCheckResult> action) {
        boolean isPlayerFlag = this.result.getFlagCheck().getRegionFlag().isPlayerFlag();
        if (this.state() == FlagState.DENIED && isPlayerFlag && action != null) {
            action.andThen(MessageSender::sendFlagMsg).accept(this.result);
        }
        return this;
    }

    public FlagEvaluator onDefault(Consumer<FlagCheckResult> action) {
        if ((this.state() == FlagState.DISABLED || this.state() == FlagState.UNDEFINED) && action != null) {
            action.accept(this.result);
        }
        return this;
    }

    public static FlagState processCheck(@NotNull FlagCheckEvent checkEvent, @Nullable Consumer<FlagCheckResult> onAllow, @Nullable Consumer<FlagCheckResult> onDeny) {
        FlagCheckResult result = FlagEvaluator.evaluate(checkEvent);
        result = Services.EVENT.post(result);
        FlagState state = result.getFlagState();
        switch (state) {
            case ALLOWED: {
                if (onAllow == null) break;
                onAllow.accept(result);
                break;
            }
            case DENIED: {
                if (onDeny == null) break;
                onDeny.accept(result);
            }
        }
        return state;
    }

    public static FlagEvaluator process(@NotNull FlagCheckEvent checkEvent) {
        FlagCheckResult result = FlagEvaluator.evaluate(checkEvent);
        result = Services.EVENT.post(result);
        return new FlagEvaluator(result);
    }

    public static FlagState processCheckF(@NotNull FlagCheckEvent checkEvent, @Nullable Function<FlagCheckResult, FlagState> handleResult) {
        FlagCheckResult result = FlagEvaluator.evaluate(checkEvent);
        result = Services.EVENT.post(result);
        if (handleResult != null) {
            return handleResult.apply(result);
        }
        return result.getFlagState();
    }

    public static FlagState processCheck(@NotNull FlagCheckEvent checkEvent, @Nullable Consumer<FlagCheckResult> onDeny) {
        return FlagEvaluator.processCheck(checkEvent, null, onDeny);
    }

    public static FlagState processCheck(@NotNull FlagCheckEvent checkEvent) {
        return FlagEvaluator.processCheck(checkEvent, null, null);
    }

    public static FlagCheckResult evaluate(FlagCheckEvent checkEvent) {
        IProtectedRegion targetRegion = FlagEvaluator.findResponsibleRegion(checkEvent.getTarget(), checkEvent.getDimension());
        if (targetRegion == null) {
            return FlagCheckResult.Undefined(checkEvent);
        }
        RegionFlag regionFlag = checkEvent.getRegionFlag();
        FlagContext flagContext = new FlagContext(targetRegion, regionFlag, targetRegion.getFlag(regionFlag.name), checkEvent.getPlayer());
        FlagContext resultingContext = FlagEvaluator.resolveFlag(targetRegion, flagContext);
        return new FlagCheckResult(checkEvent, resultingContext);
    }

    public static FlagContext resolveFlag(IProtectedRegion region, FlagContext flagContext) {
        if (FlagEvaluator.isRootRegion(region)) {
            return flagContext;
        }
        FlagContext parentFlagContext = FlagContext.parentOf(region, flagContext.regionFlag(), flagContext.player());
        FlagContext merged = flagContext.inheritContext(parentFlagContext);
        return FlagEvaluator.resolveFlag(region.getParent(), merged);
    }

    public static boolean isRootRegion(@NotNull IProtectedRegion region) {
        return region.equals(region.getParent()) && region.getRegionType() == RegionType.GLOBAL;
    }

    @Nullable
    public static IProtectedRegion findResponsibleRegion(@NotNull class_2338 pos, @NotNull class_5321<class_1937> dim) {
        IMarkableRegion localRegion = FlagEvaluator.getInvolvedRegionFor(pos, dim);
        if (localRegion == null) {
            DimensionalRegion dimRegion = RegionDataManager.getOrCreate(dim).getDim();
            if (dimRegion.isActive()) {
                return dimRegion;
            }
            GlobalRegion globalRegion = RegionManager.get().getGlobalRegion();
            return globalRegion.isActive() ? globalRegion : null;
        }
        return localRegion;
    }

    private static List<IMarkableRegion> getInvolvedRegionsFor(class_2338 position, class_5321<class_1937> dim) {
        return RegionDataManager.getLocalsFor(dim).stream().filter(IProtectedRegion::isActive).filter(region -> region.contains(position)).collect(Collectors.toList());
    }

    @Nullable
    private static IMarkableRegion getInvolvedRegionFor(class_2338 position, class_5321<class_1937> dim) {
        List<IMarkableRegion> regionsForPos = FlagEvaluator.getInvolvedRegionsFor(position, dim);
        if (regionsForPos.isEmpty()) {
            return null;
        }
        return Collections.max(regionsForPos, Comparator.comparing(IMarkableRegion::getPriority));
    }

    public static void checkMobGrief(class_1297 entity, CallbackInfo ci) {
        FlagEvaluator.checkMobGrief(entity.method_37908(), entity.method_23312(), ci);
    }

    public static void checkMobGrief(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        FlagEvaluator.checkMobGrief(entity.method_37908(), entity.method_23312(), cir);
    }

    public static void checkMobGrief(class_1937 world, class_2338 pos, CallbackInfo ci) {
        if (HandlerUtil.isServerSide(world)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(pos, RegionFlag.MOB_GRIEFING, (class_5321<class_1937>)world.method_27983());
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> ci.cancel());
        }
    }

    public static void checkMobGrief(class_1937 world, class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        if (HandlerUtil.isServerSide(world)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(pos, RegionFlag.MOB_GRIEFING, (class_5321<class_1937>)world.method_27983());
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue((Object)false));
        }
    }
}

