/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.config;

import de.z0rdak.yawp.config.server.FlagConfig;
import de.z0rdak.yawp.config.server.LoggingConfig;
import de.z0rdak.yawp.config.server.PermissionConfig;
import de.z0rdak.yawp.config.server.RegionConfig;
import de.z0rdak.yawp.core.flag.FlagFrequency;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConfigRegistry {
    public static final Logger CONFIG_LOGGER = LogManager.getLogger((String)("yawp".toUpperCase() + "-Config"));

    private ConfigRegistry() {
    }

    public static void onModLoaded(String configName, Runnable registerHandler) {
        switch (configName) {
            case "yawp-common.toml": {
                int numOfUuidsWithPermission = PermissionConfig.UUIDsWithPermission().size();
                String uuidsWithPermission = numOfUuidsWithPermission > 0 ? ": " + String.join((CharSequence)", ", PermissionConfig.UUIDsWithPermission()) : "";
                PermissionConfig.PERMISSION_CONFIG_LOGGER.info("{} UUID(s) with permission read from config{}", (Object)numOfUuidsWithPermission, (Object)uuidsWithPermission);
                PermissionConfig.PERMISSION_CONFIG_LOGGER.info("Required OP level to use commands: {}", (Object)PermissionConfig.getRequiredOpLevel());
                PermissionConfig.PERMISSION_CONFIG_LOGGER.info("Command block execution: {}", (Object)(PermissionConfig.isCommandBlockExecutionAllowed() ? "enabled" : "disabled"));
                PermissionConfig.PERMISSION_CONFIG_LOGGER.info("Region info commands for all players: {}", (Object)(PermissionConfig.isReadOnlyAllowed() ? "enabled" : "disabled"));
                PermissionConfig.PERMISSION_CONFIG_LOGGER.info("Region-Hierarchy ownership: {}", (Object)(PermissionConfig.isHierarchyOwnershipEnabled() ? "enabled" : "disabled"));
                PermissionConfig.PERMISSION_CONFIG_LOGGER.info("OP bypassing flags: {}", (Object)(PermissionConfig.byPassFlagAllowed() ? "enabled" : "disabled"));
                PermissionConfig.PERMISSION_CONFIG_LOGGER.info("Commands for non OPs: {}", (Object)(PermissionConfig.isCmdEnabledForNonOp() ? "enabled" : "disabled"));
                PermissionConfig.PERMISSION_CONFIG_LOGGER.info("RegionMarker creation: {}", (Object)(PermissionConfig.isMarkerCreationEnabled() ? "enabled" : "disabled"));
                PermissionConfig.PERMISSION_CONFIG_LOGGER.info("Region teleportation: {}", (Object)(PermissionConfig.allowRegionTp() ? "enabled" : "disabled"));
                break;
            }
            case "yawp-region-defaults.toml": {
                int numLocalDefaultFlags = RegionConfig.getDefaultFlags().size();
                String loadedLocalFlags = numLocalDefaultFlags > 0 ? ": " + String.join((CharSequence)", ", RegionConfig.getDefaultFlags()) : "";
                RegionConfig.REGION_CONFIG_LOGGER.info("{} default flag(s) for Local Regions read from config{}", (Object)numLocalDefaultFlags, (Object)loadedLocalFlags);
                int numDimDefaultFlags = RegionConfig.getDefaultDimFlags().size();
                String loadedDimFlags = numDimDefaultFlags > 0 ? ": " + String.join((CharSequence)", ", RegionConfig.getDefaultDimFlags()) : "";
                RegionConfig.REGION_CONFIG_LOGGER.info("{} default flag(s) for Dimensional Regions read from config{}", (Object)numDimDefaultFlags, (Object)loadedDimFlags);
                RegionConfig.REGION_CONFIG_LOGGER.info("Enabling newly created Dimensional Regions: {}", (Object)(RegionConfig.shouldActivateNewDimRegion() ? "enabled" : "disabled"));
                break;
            }
            case "yawp-flags.toml": {
                int numBreakEntityEntries = FlagConfig.getCoveredBlockEntities().size();
                String loadedBreakEntities = numBreakEntityEntries > 0 ? ": " + String.join((CharSequence)", ", FlagConfig.getCoveredBlockEntities()) : "";
                FlagConfig.FLAG_CONFIG_LOGGER.info("{} Block Entity entries read from config{}", (Object)numBreakEntityEntries, (Object)loadedBreakEntities);
                int numBreakEntityTagEntries = FlagConfig.getCoveredBlockEntityTags().size();
                String loadedBreakEntityTags = numBreakEntityTagEntries > 0 ? ": " + String.join((CharSequence)", ", FlagConfig.getCoveredBlockEntityTags()) : "";
                FlagConfig.FLAG_CONFIG_LOGGER.info("{} Block Entity tag entries read from config{}", (Object)numBreakEntityTagEntries, (Object)loadedBreakEntityTags);
                FlagConfig.FLAG_CONFIG_LOGGER.info("Remove entities when enabling spawning flags: {}", (Object)(FlagConfig.removeEntitiesEnabled() ? "enabled" : "disabled"));
                int amountOfDisabledFlags = FlagConfig.getDisabledFrequencyFlags(FlagFrequency.VERY_HIGH).size();
                String disabledFlagsStr = amountOfDisabledFlags > 0 ? ": " + String.join((CharSequence)", ", FlagConfig.getDisabledFrequencyFlags(FlagFrequency.VERY_HIGH)) : "";
                FlagConfig.FLAG_CONFIG_LOGGER.info("{} Disabled high frequency flags{}", (Object)disabledFlagsStr, (Object)disabledFlagsStr);
                break;
            }
            case "yawp-logging.toml": {
                LoggingConfig.LOGGING_CONFIG_LOGGER.info("Logging flag checks: {}", (Object)LoggingConfig.shouldLogFlagChecks());
                LoggingConfig.LOGGING_CONFIG_LOGGER.info("Logging flag check results: {}", (Object)LoggingConfig.shouldLogFlagCheckResults());
                LoggingConfig.LOGGING_CONFIG_LOGGER.info("Logging empty flag results: {}", (Object)LoggingConfig.shouldLogEmptyResults());
                LoggingConfig.LOGGING_CONFIG_LOGGER.info("Logging flag categories: [{}]", (Object)String.join((CharSequence)",", LoggingConfig.getFlagTags()));
                LoggingConfig.LOGGING_CONFIG_LOGGER.info("Logging flag results: [{}]", (Object)String.join((CharSequence)",", LoggingConfig.getResultValuesToLog()));
                LoggingConfig.LOGGING_CONFIG_LOGGER.info("Logging flags: [{}]", (Object)String.join((CharSequence)",", LoggingConfig.getFlagsToLog()));
                registerHandler.run();
            }
        }
    }

    public static void onModReloaded(String configName, Runnable reloadHandler) {
        CONFIG_LOGGER.info("Reloaded: '{}'", (Object)configName);
        reloadHandler.run();
    }
}

