/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.data.region;

import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.core.flag.BooleanFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.GlobalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.data.region.GlobalRegionData;
import de.z0rdak.yawp.data.region.LevelListData;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionDataManager {
    public static final Logger LOGGER = LogManager.getLogger((String)("yawp".toUpperCase(Locale.ROOT) + "-DataManager"));
    private static MinecraftServer serverInstance;
    private static LevelListData savedLevelData;
    private static GlobalRegionData globalRegionData;
    private static final Map<class_2960, LevelRegionData> dimRegionStorage;

    public static LevelListData getSavedLevelData() {
        return savedLevelData;
    }

    public static Set<class_2960> getLevels() {
        return new HashSet<class_2960>(savedLevelData.getLevels());
    }

    public static boolean hasLevel(class_2960 level) {
        return savedLevelData.hasDimEntry(level);
    }

    public static Set<String> getLevelNames() {
        return RegionDataManager.getLevels().stream().map(class_2960::toString).collect(Collectors.toSet());
    }

    public static GlobalRegionData getGlobalRegionData() {
        return globalRegionData;
    }

    public static GlobalRegion getGlobalRegion() {
        return RegionDataManager.getGlobalRegionData().getGlobal();
    }

    private RegionDataManager() {
    }

    public static void save() {
        RegionDataManager.save(true);
    }

    public static void save(boolean force) {
        if (force) {
            RegionDataManager.saveDimList(serverInstance);
            RegionDataManager.saveGlobalData(serverInstance);
            RegionDataManager.saveTrackedLevels(serverInstance);
        } else {
            savedLevelData.method_80();
            globalRegionData.method_80();
            dimRegionStorage.forEach((key, value) -> value.method_80());
        }
    }

    public static LevelListData getSavedDims() {
        if (savedLevelData == null && serverInstance != null) {
            class_3218 overworld = serverInstance.method_30002();
            if (!overworld.field_9236) {
                class_26 storage = overworld.method_17983();
                savedLevelData = (LevelListData)storage.method_17924(LevelListData.TYPE);
            }
        }
        return savedLevelData;
    }

    public static void onServerStarting(MinecraftServer server) {
        LOGGER.info(class_2561.method_48321((String)"data.region.init", (String)"Initializing RegionDataManager...").getString());
        serverInstance = server;
        RegionDataManager.checkYawpDir(server);
    }

    private static void saveTrackedLevels(MinecraftServer server) {
        server.method_3738().forEach(level -> {
            class_2960 levelRl = level.method_27983().method_29177();
            if (savedLevelData.hasDimEntry(levelRl)) {
                RegionDataManager.saveLevelData(server, (class_1937)level);
            }
        });
    }

    public static void save(MinecraftServer server, boolean flush, boolean force) {
        LOGGER.info(class_2561.method_48321((String)"data.region.levels.save.forced", (String)"Requested save. Saving region data for all levels").getString());
        if (serverInstance == null) {
            serverInstance = server;
        }
        RegionDataManager.save(force);
    }

    private static void saveDimList(MinecraftServer server) {
        class_26 dataStorage = server.method_30002().method_17983();
        dataStorage.method_123(LevelListData.TYPE, (class_18)savedLevelData);
    }

    private static void saveGlobalData(MinecraftServer server) {
        class_26 dataStorage = server.method_30002().method_17983();
        dataStorage.method_123(GlobalRegionData.TYPE, (class_18)globalRegionData);
    }

    private static void saveLevelData(MinecraftServer server, class_1937 level) {
        class_26 storage = server.method_30002().method_17983();
        class_2960 levelRl = level.method_27983().method_29177();
        LevelRegionData levelRegionData = dimRegionStorage.get(levelRl);
        LOGGER.info(class_2561.method_48322((String)"data.region.level.save", (String)"Saving region data for level '%s'", (Object[])new Object[]{levelRl.toString()}).getString());
        storage.method_123(LevelRegionData.buildSavedDataType(levelRl), (class_18)levelRegionData);
        levelRegionData.method_80();
    }

    private static LevelRegionData loadLevelData(MinecraftServer server, class_1937 level) {
        class_26 storage = server.method_30002().method_17983();
        class_2960 dimLoc = level.method_27983().method_29177();
        return (LevelRegionData)storage.method_20786(LevelRegionData.buildSavedDataType(dimLoc));
    }

    public static void saveOnStop(MinecraftServer server) {
        if (serverInstance == null) {
            serverInstance = server;
        }
        LOGGER.info(class_2561.method_48321((String)"data.region.levels.save.stopped", (String)"Stopping server. Saving region data for all levels").getString());
        RegionDataManager.save(true);
    }

    public static void saveOnUnload(MinecraftServer server, class_3218 level) {
        if (savedLevelData.hasDimEntry(level.method_27983().method_29177())) {
            LOGGER.info(class_2561.method_48322((String)"data.region.level.save.unload", (String)"Unloading level '%s'. Saving region data", (Object[])new Object[]{level.method_27983().method_29177().toString()}).getString());
            RegionDataManager.saveLevelData(server, (class_1937)level);
        }
    }

    public static void loadLevelListData(MinecraftServer server) {
        try {
            class_26 dataStorage;
            if (serverInstance == null) {
                serverInstance = server;
            }
            if ((savedLevelData = (LevelListData)(dataStorage = server.method_30002().method_17983()).method_20786(LevelListData.TYPE)) == null) {
                LOGGER.info(class_2561.method_48321((String)"data.region.levels.load.missing", (String)"Missing level list for region data (ignore on first startup). Initializing...").getString());
                savedLevelData = new LevelListData();
                RegionDataManager.saveDimList(server);
            }
            LOGGER.info(class_2561.method_48322((String)"data.region.levels.load.success", (String)"Found region data for %s dimension(s)", (Object[])new Object[]{savedLevelData.getLevels().size()}).getString());
            globalRegionData = (GlobalRegionData)dataStorage.method_20786(GlobalRegionData.TYPE);
            if (globalRegionData == null) {
                LOGGER.info(class_2561.method_48321((String)"data.region.global.missing", (String)"Missing global region data (ignore on first startup). Initializing...").getString());
                globalRegionData = new GlobalRegionData();
                RegionDataManager.saveGlobalData(server);
            }
        }
        catch (NullPointerException npe) {
            LOGGER.error(class_2561.method_48321((String)"data.region.level.local.load.failed", (String)"Loading level region list failed!").getString(), (Throwable)npe);
        }
    }

    public static void worldLoad(MinecraftServer server, class_3218 level) {
        try {
            class_2960 levelRl;
            if (serverInstance == null) {
                serverInstance = server;
            }
            if (savedLevelData.hasDimEntry(levelRl = level.method_27983().method_29177())) {
                LevelRegionData levelRegionData = RegionDataManager.loadLevelData(server, (class_1937)level);
                if (levelRegionData == null) {
                    levelRegionData = new LevelRegionData(levelRl);
                    LOGGER.info(class_2561.method_48322((String)"data.region.level.local.missing", (String)"Initializing region data for '%s'", (Object[])new Object[]{levelRl.toString()}).getString());
                    dimRegionStorage.put(levelRl, levelRegionData);
                    RegionDataManager.saveLevelData(server, (class_1937)level);
                } else {
                    LOGGER.info(class_2561.method_48322((String)"data.region.level.local.load.success", (String)"Loaded %s region(s) for '%s'", (Object[])new Object[]{levelRegionData.regionCount(), levelRl.toString()}).getString());
                    dimRegionStorage.put(levelRl, levelRegionData);
                    savedLevelData.addDimEntry(levelRl);
                }
                LOGGER.info(class_2561.method_48322((String)"data.region.level.local.load.restore", (String)"Restoring region hierarchy for '%s'.", (Object[])new Object[]{levelRl.toString()}).getString());
                DimensionalRegion dimensionalRegion = levelRegionData.getDim();
                RegionManager.get().getGlobalRegion().addChild(dimensionalRegion);
                RegionDataManager.restoreHierarchy(levelRegionData, dimensionalRegion);
                levelRegionData.getLocals().forEach((regionName, region) -> RegionDataManager.restoreHierarchy(dimRegionStorage.get(levelRl), region));
            }
        }
        catch (NullPointerException npe) {
            LOGGER.error(class_2561.method_48321((String)"data.region.level.local.load.failed", (String)"Loading regions failed!").getString(), (Throwable)npe);
        }
    }

    private static void restoreHierarchy(LevelRegionData levelRegionData, IProtectedRegion region) {
        ArrayList<String> childNames = new ArrayList<String>(region.getChildrenNames());
        childNames.forEach(childName -> {
            if (!levelRegionData.hasLocal((String)childName)) {
                LOGGER.warn(class_2561.method_48322((String)"data.region.level.local.load.restore.failed", (String)"No region with name '%s' found in save data of '%s'! Your region data is most likely corrupt.", (Object[])new Object[]{childName, levelRegionData.getId().toString()}).getString());
            } else {
                IMarkableRegion child = levelRegionData.getLocal((String)childName);
                if (child != null) {
                    levelRegionData.getDim().removeChild(child);
                    region.addChild(child);
                }
            }
        });
    }

    private static void checkYawpDir(MinecraftServer server) {
        Path worldRootPath = server.method_27050(class_5218.field_24188).normalize();
        Path dataDirPath = worldRootPath.resolve("data/yawp");
        if (Files.notExists(dataDirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dataDirPath, new FileAttribute[0]);
                LOGGER.info(class_2561.method_48322((String)"data.region.env.init", (String)"Created region data directory '%s'", (Object[])new Object[]{dataDirPath.toString()}).getString());
            }
            catch (IOException e) {
                LOGGER.error(class_2561.method_48321((String)"data.region.env.error", (String)"Failed to create directory for region data: '%s'").getString(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static void initLevelDataOnLogin(class_1297 entity, class_1937 level) {
        if (HandlerUtil.isServerSide(level) && entity instanceof class_1657) {
            RegionDataManager.initLevelData(level.method_27983().method_29177());
        }
    }

    public static void initLevelDataOnChangeWorld(class_1657 player, class_1937 srcLvl, class_1937 dstLvl) {
        if (HandlerUtil.isServerSide(srcLvl)) {
            RegionDataManager.initLevelData(dstLvl.method_27983().method_29177());
        }
    }

    private static LevelRegionData initLevelData(class_2960 rl) {
        if (!savedLevelData.hasDimEntry(rl)) {
            LevelRegionData levelRegionData = new LevelRegionData(rl);
            DimensionalRegion dimensionalRegion = levelRegionData.getDim();
            Set<String> defaultDimFlags = Services.REGION_CONFIG.getDefaultDimFlags();
            defaultDimFlags.stream().map(RegionFlag::fromId).forEach(flag -> dimensionalRegion.addFlag(new BooleanFlag((RegionFlag)((Object)flag))));
            dimensionalRegion.setIsActive(Services.REGION_CONFIG.shouldActivateNewDimRegion());
            RegionManager.get().getGlobalRegion().addChild(dimensionalRegion);
            dimRegionStorage.put(rl, levelRegionData);
            savedLevelData.addDimEntry(rl);
            LOGGER.info(class_2561.method_48322((String)"data.region.level.init", (String)"Initializing region data for level '%s'", (Object[])new Object[]{rl.toString()}).getString());
            RegionDataManager.save(false);
            return levelRegionData;
        }
        return dimRegionStorage.get(rl);
    }

    public static Optional<LevelRegionData> getLevelRegionData(class_2960 rl) {
        if (!savedLevelData.hasDimEntry(rl)) {
            return Optional.empty();
        }
        return Optional.of(dimRegionStorage.get(rl));
    }

    public static Optional<LevelRegionData> getLevelRegionData(class_5321<class_1937> dim) {
        return RegionDataManager.getLevelRegionData(dim.method_29177());
    }

    public static LevelRegionData getOrCreate(class_2960 rl) {
        if (!savedLevelData.hasDimEntry(rl)) {
            return RegionDataManager.initLevelData(rl);
        }
        return dimRegionStorage.get(rl);
    }

    public static LevelRegionData getOrCreate(class_1937 level) {
        return RegionDataManager.getOrCreate(level.method_27983().method_29177());
    }

    public static Collection<IMarkableRegion> getLocalsFor(class_5321<class_1937> dim) {
        return RegionDataManager.getOrCreate(dim.method_29177()).getLocalList();
    }

    public static LevelRegionData getOrCreate(class_5321<class_1937> dim) {
        return RegionDataManager.getOrCreate(dim.method_29177());
    }

    public static void resetLevelData(class_2960 rl) {
        dimRegionStorage.remove(rl);
    }

    public static void resetLevelData(class_5321<class_1937> dim) {
        RegionDataManager.resetLevelData(dim.method_29177());
    }

    static {
        savedLevelData = new LevelListData();
        globalRegionData = new GlobalRegionData();
        dimRegionStorage = new HashMap<class_2960, LevelRegionData>();
    }
}

