/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.handler;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.handler.HandlerUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1439;
import net.minecraft.class_1473;
import net.minecraft.class_1621;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3986;
import net.minecraft.class_3989;
import net.minecraft.class_5321;
import net.minecraft.class_5575;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class YawpEventHandler {
    public static void removeInvolvedEntities(class_2168 src, IProtectedRegion region, RegionFlag flag) {
        class_5321 dimKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)region.getDim().method_29177());
        MinecraftServer server = src.method_9211();
        Predicate<? super class_1297> entityFilter = YawpEventHandler.getEntityFilterForFlag(flag);
        switch (region.getRegionType()) {
            case GLOBAL: {
                server.method_3738().forEach(world -> {
                    List<class_1297> entitiesToRemove = YawpEventHandler.getEntitiesToRemove(world, entityFilter, flag);
                    entitiesToRemove.forEach(e -> e.method_31745(class_1297.class_5529.field_26999));
                });
                break;
            }
            case DIMENSION: {
                class_3218 regionWorld = server.method_3847(dimKey);
                if (regionWorld == null) break;
                List<class_1297> entitiesToRemove = YawpEventHandler.getEntitiesToRemove(regionWorld, entityFilter, flag);
                entitiesToRemove.forEach(e -> e.method_31745(class_1297.class_5529.field_26999));
                break;
            }
            case LOCAL: {
                class_3218 regionWorld = server.method_3847(dimKey);
                if (regionWorld == null) break;
                List<class_1297> entitiesToRemove = YawpEventHandler.getEntitiesToRemove(regionWorld, (IMarkableRegion)region, entityFilter);
                entitiesToRemove.forEach(e -> e.method_31745(class_1297.class_5529.field_26999));
            }
        }
    }

    private static Predicate<? super class_1297> getEntityFilterForFlag(RegionFlag flag) {
        switch (flag) {
            case SPAWNING_ALL: {
                return e -> e instanceof class_1308;
            }
            case SPAWNING_MONSTER: {
                return HandlerUtil::isMonster;
            }
            case SPAWNING_ANIMAL: {
                return HandlerUtil::isAnimal;
            }
            case SPAWNING_GOLEM: {
                return e -> e instanceof class_1473 || e instanceof class_1439;
            }
            case SPAWNING_TRADER: {
                return e -> e instanceof class_3989 || e instanceof class_3986;
            }
            case SPAWNING_SLIME: {
                return e -> e instanceof class_1621;
            }
            case SPAWNING_VILLAGER: {
                return HandlerUtil::isVillager;
            }
            case SPAWNING_XP: {
                return e -> e instanceof class_1303;
            }
        }
        return e -> false;
    }

    private static List<class_1297> getEntitiesToRemove(class_3218 level, IMarkableRegion region, Predicate<? super class_1297> entityFilter) {
        List entities = level.method_18198(class_5575.method_31795(class_1297.class), entityFilter);
        return entities.stream().filter(e -> region.getArea().containsOther(new CuboidArea(e.method_24515(), e.method_24515()))).filter(YawpEventHandler::isNotPersistent).collect(Collectors.toList());
    }

    private static List<class_1297> getEntitiesToRemove(class_3218 level, Predicate<? super class_1297> entityFilter, RegionFlag flag) {
        List entities = level.method_18198(class_5575.method_31795(class_1297.class), entityFilter);
        return entities.stream().filter(e -> !YawpEventHandler.isProtectedByRegion(level, flag, e)).filter(YawpEventHandler::isNotPersistent).collect(Collectors.toList());
    }

    private static boolean isNotPersistent(class_1297 e) {
        return !YawpEventHandler.hasEnabledPersistenceFlag(e) && !e.method_16914();
    }

    private static boolean hasEnabledPersistenceFlag(class_1297 e) {
        if (e instanceof class_1308) {
            class_1308 mob = (class_1308)e;
            return mob.method_5947();
        }
        return false;
    }

    private static boolean isProtectedByRegion(class_3218 level, RegionFlag flag, class_1297 e) {
        FlagCheckEvent checkEvent = new FlagCheckEvent(e.method_24515(), flag, (class_5321<class_1937>)level.method_27983());
        FlagState flagState = FlagEvaluator.processCheck(checkEvent);
        return flagState == FlagState.ALLOWED;
    }
}

