package de.z0rdak.yawp.api.events.region;

import de.z0rdak.yawp.core.flag.RegionFlag;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;

/**
 * Event that is fired before a flag is checked.
 * Can be used to cancel the flag check.
 */
public final class FlagCheckEvent {

    /**
     * The target position of the flag check. Depending on the flag this can be a block position or an entity position.
     */
    private final class_2338 target;
    /**
     * The dimension in which the flag check is performed, can be used to get the corresponding Dimensional Region.
     */
    private final class_5321<class_1937> dimension;
    /**
     * The player that triggered the flag check, may be null when no player was involved. This depends on the checked flag.
     */
    @Nullable
    private final class_1657 player;

    /**
     * The flag that is checked.
     */
    private final RegionFlag regionFlag;

    /**
     * Internal Identifier to relate a flag check to its result.
     */
    private final String id;

    public FlagCheckEvent(class_2338 target, RegionFlag regionFlag, class_5321<class_1937> dimension, @Nullable class_1657 player) {
        this.player = player;
        this.target = target;
        this.dimension = dimension;
        this.regionFlag = regionFlag;
        this.id = UUID.randomUUID().toString();
    }

    public FlagCheckEvent(class_2338 target, RegionFlag regionFlag, class_5321<class_1937> dimension, @Nullable class_1657 player, String id) {
        this.player = player;
        this.target = target;
        this.dimension = dimension;
        this.regionFlag = regionFlag;
        this.id = id;
    }

    public FlagCheckEvent(class_2338 target, RegionFlag regionFlag, class_5321<class_1937> dimension) {
        this(target, regionFlag, dimension, null);
    }

    public String getId() {
        return id;
    }

    public class_2338 getTarget() {
        return this.target;
    }

    public RegionFlag getRegionFlag() {
        return regionFlag;
    }

    public class_5321<class_1937> getDimension() {
        return dimension;
    }

    @Nullable
    public class_1657 getPlayer() {
        return player;
    }
}