package de.z0rdak.yawp.commands;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1697;
import net.minecraft.class_2168;

public enum CommandSourceType {
    PLAYER("player"),
    SERVER("server"),
    COMMAND_BLOCK("command-block"),
    NON_PLAYER("non-player"),
    UNKNOWN("unknown");

    public final String source;

    CommandSourceType(String source) {
        this.source = source;
    }

    public static CommandSourceType of(class_2168 cmdSrc) throws IllegalArgumentException {
        if (cmdSrc == null) {
            throw new IllegalArgumentException("Command source can't be null!");
        }
        try {
            class_1297 cmdSrcEntity = cmdSrc.method_9229();
            if (!(cmdSrcEntity instanceof class_1657)) {
                if (cmdSrcEntity instanceof class_1697) {
                    return COMMAND_BLOCK;
                }
                return NON_PLAYER;
            } else {
                return PLAYER;
            }
        } catch (CommandSyntaxException e) {
            // for server and command blocks this is
            // just an exclusion procedure because it is not possible to access the direct source
            if (cmdSrc.method_9214().equals("Server")) {
                return SERVER;
            }
            return COMMAND_BLOCK;
        }
    }

    @Override
    public String toString() {
        return source;
    }
}
