package de.z0rdak.yawp.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.data.region.RegionDataManager;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class LevelRegionDataArgumentType implements ArgumentType<LevelRegionData> {

    private static final Collection<String> EXAMPLES = RegionDataManager.getLevelNames();

    private static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(
            dim -> class_2561.method_48322("cli.arg.dim.invalid", "Dimension '%s' does not exist!", dim)
    );

    public static LevelRegionDataArgumentType levelData() {
        return new LevelRegionDataArgumentType();
    }

    public static LevelRegionData getDimRegion(CommandContext<class_2168> context, String dim) throws CommandSyntaxException {
        class_2960 levelRl = context.getArgument(dim, class_2960.class);
        boolean isValidDimResourceLocation = context.getSource().method_29310().stream()
                .map(class_5321::method_29177)
                .anyMatch(loc -> loc.equals(levelRl));
        if (isValidDimResourceLocation) {
            // TODO: this just creates new lrd, fix it. Init new ones by command to make them available?
            LevelRegionData dimCache = RegionDataManager.getOrCreate(levelRl);
            if (dimCache == null) {
                throw ERROR_INVALID_VALUE.create(levelRl.toString());
            }
            return dimCache;
        } else {
            throw ERROR_INVALID_VALUE.create(levelRl.toString());
        }
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof class_2168) {
            return class_2172.method_9265(RegionDataManager.getLevelNames(), builder);
        } else {
            return Suggestions.empty();
        }
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @Override
    public LevelRegionData parse(StringReader reader) throws CommandSyntaxException {
        class_2960 levelRl = class_2960.method_12835(reader);
        if (RegionDataManager.hasLevel(levelRl)) {
            return RegionDataManager.getOrCreate(levelRl);
        }
        return null;
    }
}
