package de.z0rdak.yawp.core.region;

import de.z0rdak.yawp.constants.serialization.RegionNbtKeys;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.SphereArea;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.group.PlayerContainer;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;

public final class SphereRegion extends MarkedRegion {

    public SphereRegion(String name, SphereArea area, class_5321<class_1937> dimension) {
        this(name, area, area.getCenterPos(), null, dimension);
    }

    public SphereRegion(String name, SphereArea area, class_1657 owner, class_5321<class_1937> dimension) {
        super(name, area, area.getCenterPos(), owner, dimension);
    }

    public SphereRegion(String name, SphereArea area, class_2338 tpPos, class_1657 player, class_5321<class_1937> dimension) {
        super(name, area, tpPos, player, dimension);
    }

    public SphereRegion(String name, class_5321<class_1937> dim, String parentName, Map<String, IFlag> flags,
                        boolean isActive, boolean isMuted, int priority, IMarkableArea area, class_2338 blockPos,
                        Map<String, PlayerContainer> groups, List<String> childrenNames){
        super(name, dim, parentName, flags, isActive, isMuted, priority, AreaType.SPHERE.areaType, area, blockPos, groups, childrenNames);
    }
}
