package de.z0rdak.yawp.handler;

import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.core.flag.*;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1307;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1506;
import net.minecraft.class_1507;
import net.minecraft.class_1510;
import net.minecraft.class_1569;
import net.minecraft.class_1606;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1915;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;

public final class HandlerUtil {

    private HandlerUtil() {
    }

    public static class_5321<class_1937> getDimKey(class_1297 entity) {
        return entity.method_37908().method_27983();
    }

    public static class_5321<class_1937> getDimKey(class_1937 world) {
        return world.method_27983();
    }

    public static boolean isAnimal(class_1297 entity) {
        boolean isMonsterHorse = entity instanceof class_1507 || entity instanceof class_1506;
        // Note: because monster horses are still horses and horses are animals? what the frick mojang
        return entity instanceof class_1429 && !isMonsterHorse 
                || entity instanceof class_1480;
    }

    public static boolean isServerSide(class_1297 entity) {
        return isServerSide(entity.method_37908());
    }

    public static boolean isServerSide(class_1936 world) {
        return !world.method_8608();
    }
    public static boolean isServerSide(class_1937 world) {
        return !world.field_9236;
    }

    public static boolean isVillager(class_1297 entity) {
        return entity instanceof class_1915;
    }

    public static boolean isPlayer(class_1297 entity) {
        return entity instanceof class_1657;
    }

    public static boolean isMonster(class_1297 entity) {
        return entity instanceof class_1569
                || entity instanceof class_1621
                || entity instanceof class_1307
                || entity instanceof class_1510
                || entity instanceof class_1606 
                || entity instanceof class_1507 || entity instanceof class_1506;
    }

    public static boolean notServerSideOrPlayerNull(class_1297 entity) {
        return entity == null || !isServerSide(entity);
    }

    public static void syncPlayerInventory(class_1937 world, class_1657 player) {
        // TODO:
    }

    public static void updateBlockState(class_1937 world, class_2338 pos) {
        world.method_8408(pos, world.method_8320(pos).method_26204());
    }


    public static Map<String, FlagCorrelation> getFlagMapRecursive(IProtectedRegion region, Map<String, FlagCorrelation> carry) {
        if (carry == null) {
            carry = region.getFlags().flagEntries().stream()
                    .filter(flag -> flag.getValue().getState() != FlagState.UNDEFINED)
                    .collect(Collectors.toMap(Map.Entry::getKey, entry -> new FlagCorrelation(region, entry.getValue())));
        }
        if (region.equals(region.getParent())) {
            // global region has itself as parent
            Set<Map.Entry<String, IFlag>> flags = getNonUndefinedFlags(region);
            for (Map.Entry<String, IFlag> entry : flags) {
                if (!carry.containsKey(entry.getKey())) {
                    carry.put(entry.getValue().getName(), new FlagCorrelation(region, entry.getValue()));
                }
            }
            return carry;
        }
        Set<Map.Entry<String, IFlag>> parentFlags = getNonUndefinedFlags(region.getParent());
        for (Map.Entry<String, IFlag> entry : parentFlags) {
            if (!carry.containsKey(entry.getKey())) {
                carry.put(entry.getValue().getName(), new FlagCorrelation(region.getParent(), entry.getValue()));
            }
            if (entry.getValue().doesOverride()) {
                carry.put(entry.getValue().getName(), new FlagCorrelation(region.getParent(), entry.getValue()));
            }
        }
        return getFlagMapRecursive(region.getParent(), carry);
    }

    private static Set<Map.Entry<String, IFlag>> getNonUndefinedFlags(IProtectedRegion region) {
        return region.getFlags().flagEntries().stream()
                .filter(flag -> flag.getValue().getState() != FlagState.UNDEFINED)
                .collect(Collectors.toSet());
    }

}
