package de.z0rdak.yawp.mixin;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_2338;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2488.class)
public class SnowLayerBlockMixin {

    @Inject(method = "randomTick", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/SnowLayerBlock;dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"), cancellable = true)
    public void onRandomTick(class_2680 blockState, class_3218 level, class_2338 blockPos, class_5819 randomSource, CallbackInfo ci) {
        FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, RegionFlag.SNOW_MELTING, level.method_27983());
        if (Services.EVENT.post(checkEvent)) {
            return;
        }
        FlagEvaluator.processCheck(checkEvent, deny -> {
            ci.cancel();
        });
    }
}
