package de.z0rdak.yawp.mixin.stick;

import de.z0rdak.yawp.handler.MarkerStickHandler;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.StickType;
import net.minecraft.class_1657;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static de.z0rdak.yawp.handler.HandlerUtil.isServerSide;

// TODO: Remove with WorldEdit integration feature
@Mixin(class_1706.class)
public abstract class AnvilScreenHandlerMixin {

    @Shadow @Nullable private String itemName;

    @Inject(method = "onTake", at = @At("HEAD"), cancellable = true, allow = 1)
    private void onTakeOutput(class_1657 player, class_1799 outputItem, CallbackInfo ci) {
        if (isServerSide(player.method_37908())) {
            try {
                if (!Services.PERMISSION_CONFIG.isMarkerCreationEnabled()) {
                    return;
                }
                class_1706 anvilMenu = (class_1706) (Object) this;
                class_1799 inputItem = anvilMenu.method_7611(0).method_7677();
                class_1799 ingredientInput = anvilMenu.method_7611(1).method_7677();
                class_1799 stick = class_1802.field_8600.method_7854();
                boolean isInputAndOutputStick = class_1799.method_7984(outputItem, stick)
                        && class_1799.method_7984(inputItem, stick);
                var outputIsNamedAsMarker = this.itemName != null && this.itemName.equals(StickType.MARKER.stickName);
                if (isInputAndOutputStick && ingredientInput.method_7960() && outputIsNamedAsMarker) {
                    MarkerStickHandler.onCreateStick(player, inputItem, outputItem);
                    player.method_31548().method_5431();
                    ci.cancel();
                }
            } catch (ClassCastException cce) {
                // Should not happen - if so we ignore it simply
            }
        }
    }
}
