package de.z0rdak.yawp.util;

import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3341;

public final class AreaUtil {

    private AreaUtil() {
    }

    public static double distance(class_2338 a, class_2338 b) {
        return Math.sqrt(Math.pow(b.method_10263() - a.method_10263(), 2)
                + Math.pow(b.method_10264() - a.method_10264(), 2)
                + Math.pow(b.method_10260() - a.method_10260(), 2));
    }

    public static int distanceManhattan(class_2338 a, class_2338 b) {
        return Math.abs(b.method_10263() - a.method_10263())
                + Math.abs(b.method_10264() - a.method_10264())
                + Math.abs(b.method_10260() - a.method_10260());
    }

    public static double length(class_2338 a) {
        return Math.sqrt(Math.pow(a.method_10263(), 2)
                + Math.pow(a.method_10264(), 2)
                + Math.pow(a.method_10260(), 2));
    }

    public static String blockPosStr(class_2338 pos) {
        return new StringJoiner(", ", "[", "]")
                .add(String.valueOf(pos.method_10263()))
                .add(String.valueOf(pos.method_10264()))
                .add(String.valueOf(pos.method_10260()))
                .toString();
    }

    public static class_2338 getLowerPos(class_2338 pos1, class_2338 pos2) {
        return pos1.method_10260() < pos2.method_10260() ? pos1 : pos2;
    }

    public static class_2338 getHigherPos(class_2338 pos1, class_2338 pos2) {
        return pos1.method_10260() > pos2.method_10260() ? pos1 : pos2;
    }

    public static Set<class_2338> blocksBetweenOnAxis(class_2338 p1, class_2338 p2, class_2350.class_2351 axis) {
        class_3341 blockLine = class_3341.method_34390(p1, p2);
        Set<class_2338> blocks = new HashSet<>();
        switch (axis) {
            case field_11048:
                for (int x = blockLine.method_35415(); x <= blockLine.method_35418(); x++) {
                    blocks.add(new class_2338(x, p1.method_10264(), p1.method_10260()));
                }
                break;
            case field_11052:
                for (int y = blockLine.method_35416(); y <= blockLine.method_35419(); y++) {
                    blocks.add(new class_2338(p1.method_10263(), y, p1.method_10260()));
                }
                break;
            case field_11051:
                for (int z = blockLine.method_35417(); z <= blockLine.method_35420(); z++) {
                    blocks.add(new class_2338(p1.method_10263(), p1.method_10264(), z));
                }
                break;
        }
        return blocks;
    }

    public static Set<class_2338> blocksIn(class_3341 cube) {
        Set<class_2338> blocks = new HashSet<>();
        for (int x = cube.method_35415(); x <= cube.method_35418(); x++) {
            for (int y = cube.method_35416(); y <= cube.method_35419(); y++) {
                for (int z = cube.method_35417(); z <= cube.method_35420(); z++) {
                    blocks.add(new class_2338(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static Set<class_2338> blocksIn(class_3341 cube, Predicate<class_2338> inclusion) {
        Set<class_2338> blocks = new HashSet<>();
        for (int x = cube.method_35415(); x <= cube.method_35418(); x++) {
            for (int y = cube.method_35416(); y <= cube.method_35419(); y++) {
                for (int z = cube.method_35417(); z <= cube.method_35420(); z++) {
                    class_2338 blockPos = new class_2338(x, y, z);
                    if (inclusion.test(blockPos)) {
                        blocks.add(blockPos);
                    }
                }
            }
        }
        return blocks;
    }

    public static int blocksOnAxis(class_3341 box, class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048:
                return box.method_35414();
            case field_11052:
                return box.method_14660();
            case field_11051:
                return box.method_14663();
            default:
                throw new IllegalArgumentException();
        }
    }

    public static class_3341 getSlice(class_2338 center, int halfSize, int offset, class_2350.class_2351 axis) {
        return switch (axis) {
            case field_11048 -> {
                var p1 = center.method_10069(halfSize, halfSize, offset);
                var p2 = center.method_10069(-halfSize, -halfSize, offset);
                yield  class_3341.method_34390(p1, p2);
            }
            case field_11052 -> {
                var p1 = center.method_10069(halfSize, offset, halfSize);
                var p2 = center.method_10069(-halfSize, offset, -halfSize);
                yield class_3341.method_34390(p1, p2);
            }
            case field_11051 -> {
                var p1 = center.method_10069(offset, halfSize, halfSize);
                var p2 = center.method_10069(offset, -halfSize, -halfSize);
                yield class_3341.method_34390(p1, p2);
            }
        };
    }

    public static Set<class_2338> getSliceBlocks(class_2338 center, int halfSize, int offset, class_2350.class_2351 axis, Predicate<class_2338> include) {
        var slice = getSlice(center, halfSize, offset, axis);
        return blocksIn(slice, include);
    }
}
