package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import java.util.List;
import net.minecraft.class_2561;

import static de.z0rdak.yawp.api.commands.Commands.buildListChildRegionCommand;
import static de.z0rdak.yawp.util.ChatComponentBuilder.buildHeader;
import static de.z0rdak.yawp.util.ChatComponentBuilder.buildRemoveRegionEntries;
import static de.z0rdak.yawp.util.ChatLinkBuilder.buildRegionInfoLink;

public class ChildRegionPagination extends BasePaginationMessage<IProtectedRegion> {

    private final IProtectedRegion region;

    public ChildRegionPagination(IProtectedRegion region, List<IProtectedRegion> entries, int pageNumber, int pageSize) throws InvalidPageNumberException {
        super(entries, buildListChildRegionCommand(region), pageNumber, pageSize);
        this.region = region;
    }

    @Override
    public List<class_2561> buildEntries() {
        return buildRemoveRegionEntries(region, this.pageContent);
    }

    @Override
    public class_2561 noContentMsg() {
        return class_2561.method_48322("cli.msg.info.region.children.empty", "No children defined in region %s", buildRegionInfoLink(region));
    }

    @Override
    public class_2561 header() {
        return buildHeader(class_2561.method_48322("cli.msg.info.header.in", "== %s in %s ==", ChatLinkBuilder.buildRegionListChildrenLink(region), buildRegionInfoLink(region)));
    }

    @Override
    public class_2561 emptyEntry() {
        return class_2561.method_43469(" - %s", ChatLinkBuilder.buildRegionAddChildrenLink(region));
    }
}
