/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api;

import de.z0rdak.yawp.api.events.region.FlagCheckResult;
import de.z0rdak.yawp.core.flag.FlagMessage;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class MessageSender {
    public static void sendCmdFeedback(CommandSourceStack src, MutableComponent text) {
        src.sendSystemMessage((Component)text);
    }

    public static void message(Player player, MutableComponent msg) {
        player.displayClientMessage((Component)msg, false);
    }

    public static void message(Player player, String msg) {
        player.displayClientMessage((Component)Component.literal((String)msg), false);
    }

    public static void overLayMessage(Player player, String msg) {
        player.displayClientMessage((Component)Component.literal((String)msg), true);
    }

    public static void overLayMessage(Player player, MutableComponent msg) {
        player.displayClientMessage((Component)msg, true);
    }

    public static void sendError(CommandSourceStack src, MutableComponent text) {
        src.sendFailure((Component)text);
    }

    public static void sendNotification(Player player, MutableComponent msg) {
        player.displayClientMessage((Component)msg, true);
    }

    public static void sendFlagMsg(FlagCheckResult result) {
        IProtectedRegion responsibleRegion = result.getResponsible();
        if (responsibleRegion == null) {
            return;
        }
        IFlag flag = responsibleRegion.getFlag(result.getFlagCheck().getRegionFlag().name);
        if (flag == null || result.getFlagState() == FlagState.UNDEFINED || result.getFlagState() == FlagState.DISABLED) {
            return;
        }
        boolean isFlagMuted = flag.getFlagMsg().isMuted() || responsibleRegion.isMuted();
        Player player = result.getFlagCheck().getPlayer();
        if (!isFlagMuted && RegionFlag.hasPlayerCategory(flag) && player instanceof Player) {
            Map<String, String> msgSubstitutes = FlagMessage.defaultSubstitutesFor(result);
            msgSubstitutes.put("{region}", responsibleRegion.getName());
            MutableComponent flagMsg = FlagMessage.buildFrom(result, msgSubstitutes);
            MessageSender.sendNotification(player, flagMsg);
        }
    }
}

