/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.visualization;

import de.z0rdak.yawp.api.core.IDimensionRegionApi;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.visualization.RegionVisualizationManager;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.area.TeleportAnchor;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VisualizationManager {
    public static final Logger VISUALIZATION_LOGGER = LogManager.getLogger((String)("yawp".toUpperCase() + "-Visualization"));
    public static final ResourceLocation REGION_BLOCK_DISPLAY_TAG = ResourceLocation.parse((String)"yawp:region_block_display");
    public static final ResourceLocation REGION_TEXT_DISPLAY_TAG = ResourceLocation.parse((String)"yawp:region_text_display");
    private static MinecraftServer serverInstance;
    private static final Map<ResourceLocation, VisualizationManager> dimVisualizationManagers;
    private final Map<String, RegionVisualizationManager> regionDisplayManagers = new HashMap<String, RegionVisualizationManager>();

    public static void initServerInstance(MinecraftServer server) {
        serverInstance = server;
    }

    public static void nukeDisplayEntities(ServerLevel level) {
        List entities = level.getEntities(EntityTypeTest.forClass(Display.class), entity -> {
            boolean containsTextTag = entity.getTags().contains(REGION_TEXT_DISPLAY_TAG.toString());
            boolean containsBlockTag = entity.getTags().contains(REGION_BLOCK_DISPLAY_TAG.toString());
            return containsTextTag || containsBlockTag;
        });
        int entityAmount = entities.size();
        entities.forEach(e -> e.remove(Entity.RemovalReason.DISCARDED));
        if (entityAmount > 0) {
            VISUALIZATION_LOGGER.info("Nuked all ({}) untracked region display entities in level {}.", (Object)entityAmount, (Object)level.dimension().location().toString());
        }
    }

    private VisualizationManager() {
    }

    public static void hideRegionsAround(Player player, int radius) {
        Level level = player.level();
        BlockPos playerPos = player.blockPosition();
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi((ResourceKey<Level>)level.dimension());
        if (maybeApi.isPresent()) {
            IDimensionRegionApi dimApi = maybeApi.get();
            List<IMarkableRegion> regionsAround = dimApi.getRegionsAround(playerPos, radius);
            regionsAround.forEach(region -> {
                VisualizationManager.hide(region, DisplayType.FRAME);
                VisualizationManager.hide(region, DisplayType.HULL);
                VisualizationManager.hide(region, DisplayType.MINIMAL);
                VisualizationManager.hide(region, DisplayType.MARKED);
            });
        }
    }

    public static void showRegionsAround(Player player, int radius, DisplayType displayType) {
        Level level = player.level();
        BlockPos playerPos = player.blockPosition();
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi((ResourceKey<Level>)level.dimension());
        if (maybeApi.isPresent()) {
            IDimensionRegionApi dimApi = maybeApi.get();
            List<IMarkableRegion> regionsAround = dimApi.getRegionsAround(playerPos, radius);
            regionsAround.forEach(region -> VisualizationManager.show(region, displayType));
        }
    }

    public static void hideAllRegions(Level level, boolean untracked) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi((ResourceKey<Level>)level.dimension());
        if (maybeApi.isPresent()) {
            IDimensionRegionApi dimApi = maybeApi.get();
            Collection<IMarkableRegion> regions = dimApi.getAllLocalRegions();
            regions.forEach(region -> {
                VisualizationManager.hide(region, DisplayType.FRAME);
                VisualizationManager.hide(region, DisplayType.HULL);
                VisualizationManager.hide(region, DisplayType.MINIMAL);
                VisualizationManager.hide(region, DisplayType.MARKED);
            });
        }
        if (untracked) {
            VisualizationManager.nukeDisplayEntities((ServerLevel)level);
        }
    }

    public static void showTpAnchor(IMarkableRegion region, TeleportAnchor tpAnchor) {
        ResourceLocation levelRl = region.getDim().location();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        ServerLevel level = serverInstance.getLevel(region.getDim());
        rvm.showTpAnchor(tpAnchor, level);
    }

    public static void hideTpAnchor(IMarkableRegion region, TeleportAnchor tpAnchor) {
        ResourceLocation levelRl = region.getDim().location();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        ServerLevel level = serverInstance.getLevel(region.getDim());
        rvm.hideTpAnchor(tpAnchor, level);
    }

    public static void updateTpAnchor(IMarkableRegion region, TeleportAnchor tpAnchor) {
        ResourceLocation levelRl = region.getDim().location();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        rvm.updateTpAnchor(tpAnchor);
    }

    public static void showTeleportAnchors(IMarkableRegion region) {
        region.getTpAnchors().getAnchors().forEach(anchor -> VisualizationManager.showTpAnchor(region, anchor));
    }

    public static void hideTeleportAnchors(IMarkableRegion region) {
        region.getTpAnchors().getAnchors().forEach(anchor -> VisualizationManager.hideTpAnchor(region, anchor));
    }

    public static void show(IMarkableRegion region, DisplayType displayType, BlockDisplayProperties displayProperties) {
        ResourceLocation levelRl = region.getDim().location();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        ServerLevel level = serverInstance.getLevel(region.getDim());
        rvm.show(displayType, displayProperties, level);
    }

    private static VisualizationManager getOrCreateVisualizationManager(ResourceLocation levelRl) {
        if (!dimVisualizationManagers.containsKey(levelRl)) {
            VisualizationManager dimVm = new VisualizationManager();
            dimVisualizationManagers.put(levelRl, dimVm);
        }
        return dimVisualizationManagers.get(levelRl);
    }

    private static RegionVisualizationManager getOrCreateRegionVisualizationManager(VisualizationManager vm, IMarkableRegion region) {
        if (!vm.regionDisplayManagers.containsKey(region.getName())) {
            vm.regionDisplayManagers.put(region.getName(), new RegionVisualizationManager(region));
        }
        return vm.regionDisplayManagers.get(region.getName());
    }

    public static void show(IMarkableRegion region, DisplayType displayType) {
        VisualizationManager.show(region, displayType, region.getArea().getDisplay());
    }

    public static void hide(IMarkableRegion region, DisplayType displayType) {
        ResourceLocation levelRl = region.getDim().location();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        rvm.hide(displayType);
    }

    public static void updateRegionDisplay(IMarkableRegion region) {
        ResourceLocation levelRl = region.getDim().location();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        ServerLevel level = serverInstance.getLevel(region.getDim());
        rvm.updateDisplay(region.getArea(), level);
    }

    public static void refreshDisplay(IMarkableRegion region, DisplayType displayType) {
        ResourceLocation levelRl = region.getDim().location();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        rvm.updateDisplay(region.getArea().getDisplay(), displayType);
    }

    public static void refreshDisplay(IMarkableRegion region) {
        ResourceLocation levelRl = region.getDim().location();
        VisualizationManager vm = VisualizationManager.getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = VisualizationManager.getOrCreateRegionVisualizationManager(vm, region);
        rvm.updateDisplay(region.getArea().getDisplay(), true);
    }

    public static void showHierarchy(IMarkableRegion region, DisplayType displayType, boolean recursive) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(region.getDim());
        if (maybeApi.isEmpty()) {
            return;
        }
        Collection<IProtectedRegion> children = region.getChildren().values();
        for (IProtectedRegion child : children) {
            if (!(child instanceof IMarkableRegion)) continue;
            IMarkableRegion childRegion = (IMarkableRegion)child;
            VisualizationManager.show(childRegion, displayType);
            if (!recursive) continue;
            VisualizationManager.showHierarchy(childRegion, displayType, recursive);
        }
    }

    public static void showIntersecting(IMarkableRegion region, DisplayType displayType) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(region.getDim());
        if (maybeApi.isPresent()) {
            IDimensionRegionApi dimApi = maybeApi.get();
            List<IMarkableRegion> intersectingRegions = dimApi.getIntersectingRegions(region);
            intersectingRegions.forEach(intersectingRegion -> VisualizationManager.show(intersectingRegion, displayType));
        }
    }

    public static void hideHierarchy(IMarkableRegion region, DisplayType displayType, boolean recursive) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(region.getDim());
        if (maybeApi.isEmpty()) {
            return;
        }
        Collection<IProtectedRegion> children = region.getChildren().values();
        for (IProtectedRegion child : children) {
            if (!(child instanceof IMarkableRegion)) continue;
            IMarkableRegion childRegion = (IMarkableRegion)child;
            VisualizationManager.hide(childRegion, displayType);
            if (!recursive) continue;
            VisualizationManager.hideHierarchy(childRegion, displayType, recursive);
        }
    }

    public static void hideIntersecting(IMarkableRegion region, DisplayType displayType) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(region.getDim());
        if (maybeApi.isPresent()) {
            IDimensionRegionApi dimApi = maybeApi.get();
            List<IMarkableRegion> intersectingRegions = dimApi.getIntersectingRegions(region);
            intersectingRegions.forEach(intersectingRegion -> VisualizationManager.hide(intersectingRegion, displayType));
        }
    }

    static {
        dimVisualizationManagers = new HashMap<ResourceLocation, VisualizationManager>();
    }
}

