/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.MarkedArea;
import de.z0rdak.yawp.core.area.MarkedAreaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.apache.commons.lang3.NotImplementedException;

public class Polygon3DArea
extends MarkedArea {
    private List<BlockPos> positions = new ArrayList<BlockPos>();

    private Polygon3DArea() {
        super(AreaType.POLYGON_3D);
    }

    public Polygon3DArea(List<BlockPos> positions) {
        this();
        this.positions = positions;
    }

    private static double calcAngleSum(BlockPos q, List<BlockPos> posList, int n) {
        double ESPILON = 1.0E-7;
        double angleSum = 0.0;
        for (int i = 0; i < n; ++i) {
            double m2;
            BlockPos p1 = posList.get(i).subtract((Vec3i)q);
            BlockPos p2 = posList.get((i + 1) % n).subtract((Vec3i)q);
            double m1 = Polygon3DArea.modulus(p1);
            if (m1 * (m2 = Polygon3DArea.modulus(p2)) <= 1.0E-7) {
                return Math.PI * 2;
            }
            double cosTheta = (double)(p1.getX() * p2.getX() + p1.getY() * p2.getY()) + (double)(p1.getZ() * p2.getZ()) / (m1 * m2);
            angleSum += Math.acos(cosTheta);
        }
        return angleSum;
    }

    private static double modulus(BlockPos p) {
        return Math.sqrt(p.getX() * p.getX() + p.getY() * p.getY() + p.getZ() * p.getZ());
    }

    public List<BlockPos> getPositions() {
        return Collections.unmodifiableList(this.positions);
    }

    @Override
    public boolean contains(BlockPos q) {
        return Polygon3DArea.calcAngleSum(q, this.positions, this.positions.size()) == Math.PI * 2;
    }

    public String toString() {
        throw new NotImplementedException("Missing toString");
    }

    @Override
    public Set<BlockPos> markedBlocks() {
        return new HashSet<BlockPos>(this.positions);
    }

    @Override
    public Set<BlockPos> getHull() {
        throw new NotImplementedException("Polygon3DArea.getHull() not implemented yet");
    }

    @Override
    public Set<BlockPos> getFrame() {
        return Set.of();
    }

    @Override
    public Set<BlockPos> getMinimalOutline() {
        return Set.of();
    }

    @Override
    public boolean containsOther(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public boolean intersects(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public MarkedAreaType<?> getType() {
        return null;
    }
}

