package de.z0rdak.yawp.core.area;

import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;

/**
 * IMarkableArea provides an interface for different types of areas.
 * The most basic area would be a simple AxisAlignedBB.
 * This type of mark-able area is already implemented in the class CuboidArea.
 */
public interface IMarkableArea {

    boolean contains(class_2338 pos);

    AreaType getAreaType();

    Set<class_2338> markedBlocks();

    /**
     * Set containing all block positions which represent the outer hull of the marked area.
     * The hull is the solid outer perimeter of the marked area.
     */
    Set<class_2338> getHull();

    /**
     * Set containing all block positions which represent the outer frame of the marked area.
     * The frame is the minimum required blocks to give a rough outline o the marked area
     */
    Set<class_2338> getFrame();
    Set<class_2338> getMinimalOutline();

    boolean containsOther(IMarkableArea other);

    boolean intersects(IMarkableArea other);

    MarkedAreaType<?> getType();


    BlockDisplayProperties getDisplay();

    void updateDisplay(BlockDisplayProperties properties);
}
