package de.z0rdak.yawp.data.region;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.constants.Constants;
import java.util.*;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_2960;

public class LevelListData extends class_18 {

    public static final String DIMENSIONS_FILE_NAME = "dimensions";

    public static Codec<LevelListData> LEVEL_LIST_CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    Codec.list(class_2960.field_25139).optionalFieldOf("dims", new ArrayList<>())
                            .forGetter(LevelListData::getLevels)
            ).apply(instance, LevelListData::new));
    public final static class_10741<LevelListData> TYPE = new class_10741<>(
            String.join("/", Constants.MOD_ID, DIMENSIONS_FILE_NAME),
            (ctx) -> new LevelListData(),
            (ctx) -> LEVEL_LIST_CODEC,
            null);

    private final Set<class_2960> dimensions;

    public LevelListData(List<class_2960> dims){
        this.dimensions = new HashSet<>(dims);
    }

    public LevelListData(){
        this.dimensions = new HashSet<>();
    }

    public List<class_2960> getLevels() {
        return new ArrayList<>(this.dimensions);
    }

    public void addDimEntry(class_2960 rl) {
        this.dimensions.add(rl);
    }

    public boolean hasDimEntry(class_2960 rl) {
        return this.dimensions.contains(rl);
    }
}

