package de.z0rdak.yawp.mixin.flag;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1915;
import net.minecraft.class_3218;
import net.minecraft.class_5454;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static de.z0rdak.yawp.core.flag.RegionFlag.*;
import static de.z0rdak.yawp.handler.HandlerUtil.*;
import static de.z0rdak.yawp.api.MessageSender.sendFlagMsg;

@Mixin(class_1297.class)
public abstract class EntityMixin {

    @Inject(method = "startRiding(Lnet/minecraft/world/entity/Entity;Z)Z", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void spawnChildFromBreeding(class_1297 vehicle, boolean force, CallbackInfoReturnable<Boolean> cir) {
        class_1297 rider = (class_1297) (Object) this;
        if (isServerSide(rider)) {
            if (rider instanceof class_1657 player) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(vehicle.method_24515(), ANIMAL_MOUNTING, getDimKey(vehicle), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    cir.setReturnValue(false);
                });
            }
        }
    }

    @Inject(method = "thunderHit", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onHitByLightning(class_3218 world, class_1538 lightning, CallbackInfo ci) {
        class_1297 poorSoul = (class_1297) (Object) this;
        if (isServerSide(poorSoul)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(poorSoul.method_24515(), LIGHTNING_PROT, getDimKey(poorSoul), null);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                ci.cancel();
            });
        }
    }

    @Inject(method = "stopRiding", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void spawnChildFromBreeding(CallbackInfo ci) {
        class_1297 rider = (class_1297) (Object) this;
        if (isServerSide(rider)) {
            if (rider instanceof class_1657 player) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), ANIMAL_UNMOUNTING, getDimKey(player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    ci.cancel();
                });
            }
        }
    }

    /**
     * Covers USE_PORTAL* flags
     * Note: does not seem to trigger for players, which is fine
     */
    @Inject(method = "teleportCrossDimension", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onChangeDimension(class_3218 from, class_3218 to, class_5454 teleportTransition, CallbackInfoReturnable<class_1297> cir) {
        class_1297 self = (class_1297) (Object) this;
        if (isServerSide(from)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), USE_PORTAL, getDimKey(from));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                cir.setReturnValue(null);
            });
            if (self instanceof class_1657 player) {
                checkEvent = new FlagCheckEvent(self.method_24515(), USE_PORTAL_PLAYERS, getDimKey(from), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    cir.setReturnValue(null);
                });
            }
            if (self instanceof class_1542) {
                checkEvent = new FlagCheckEvent(self.method_24515(), USE_PORTAL_ITEMS, getDimKey(from));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    cir.setReturnValue(null);
                });
            }
            if (isAnimal(self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), USE_PORTAL_ANIMALS, getDimKey(from));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    cir.setReturnValue(null);
                });
            }
            if (isMonster(self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), USE_PORTAL_MONSTERS, getDimKey(from));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    cir.setReturnValue(null);
                });
            }
            if (self instanceof class_1915) {
                checkEvent = new FlagCheckEvent(self.method_24515(), USE_PORTAL_VILLAGERS, getDimKey(from));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    cir.setReturnValue(null);
                });
            }
            if (self instanceof class_1688) {
                checkEvent = new FlagCheckEvent(self.method_24515(), USE_PORTAL_MINECARTS, getDimKey(from));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    cir.setReturnValue(null);
                });
            }
        }
    }
}
