package de.z0rdak.yawp.mixin.flag.mobgrief;

import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4217;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static de.z0rdak.yawp.core.flag.RegionFlag.MOB_GRIEFING;
import static de.z0rdak.yawp.api.FlagEvaluator.processCheck;

@Mixin(class_4217.class)
public class HarvestFarmlandMixin {

    /**
     * Check if the provided BlockPos is a suitable target for the farmer villager to harvest.
     * Tells the farmer villager ai that the given block is not suitable for farming, preventing the mob griefing in the progress
     * (considering the flag state)
     * This way of handling the position in this particular case is way better than forge does with its mobgriefing event.
     */
    @Inject(method = "validPos", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    void isBlockSuitableTarget(class_2338 pos, class_3218 world, CallbackInfoReturnable<Boolean> cir) {
        FlagCheckEvent checkEvent = new FlagCheckEvent(pos, MOB_GRIEFING, world.method_27983(), null);
        if (Services.EVENT.post(checkEvent))
            return;
        processCheck(checkEvent, deny -> {
            cir.setReturnValue(false);
        });
    }
}
