/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.stick;

import de.z0rdak.yawp.core.INbtSerializable;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.stick.AbstractStick;
import de.z0rdak.yawp.util.NbtCompatHelper;
import de.z0rdak.yawp.util.StickType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class MarkerStick
extends AbstractStick
implements INbtSerializable<CompoundTag> {
    private ResourceKey<Level> dimension;
    private AreaType areaType;
    private boolean isValidArea;
    private List<BlockPos> markedBlocks;

    public MarkerStick(ResourceKey<Level> dim) {
        super(StickType.MARKER);
        this.areaType = AreaType.CUBOID;
        this.isValidArea = false;
        this.markedBlocks = new ArrayList<BlockPos>(this.areaType.maxBlocks);
        this.dimension = dim;
    }

    public MarkerStick(CompoundTag nbt) {
        super(StickType.MARKER);
        this.deserializeNBT(nbt);
    }

    @Override
    public void cycleMode() {
        this.areaType = AreaType.values()[(this.areaType.ordinal() + 1) % AreaType.values().length];
        this.reset();
    }

    public void reset() {
        this.markedBlocks = new ArrayList<BlockPos>(this.areaType.maxBlocks);
        this.isValidArea = false;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public boolean checkValidArea() {
        int numMarkedBlocks = this.markedBlocks.size();
        if (this.markedBlocks.isEmpty() || this.areaType.neededBlocks == -1) {
            return false;
        }
        boolean exactlyEnoughBlocks = numMarkedBlocks == this.areaType.neededBlocks && numMarkedBlocks == this.areaType.maxBlocks;
        boolean minBlocks = numMarkedBlocks >= this.areaType.neededBlocks && numMarkedBlocks <= this.areaType.maxBlocks;
        this.isValidArea = exactlyEnoughBlocks || minBlocks;
        return this.isValidArea;
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
    }

    public boolean isValidArea() {
        return this.isValidArea;
    }

    public List<BlockPos> getMarkedBlocks() {
        return this.markedBlocks;
    }

    public void addMarkedBlock(BlockPos pos) {
        int index = this.markedBlocks.size() % this.areaType.maxBlocks;
        this.markedBlocks.add(index, pos);
        if (this.markedBlocks.size() > this.areaType.maxBlocks) {
            this.markedBlocks.remove(this.areaType.maxBlocks);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.putString("stick-id", UUID.randomUUID().toString());
        nbt.putBoolean("valid", this.isValidArea);
        nbt.putString("type", this.areaType.areaType);
        nbt.putString("dim", this.dimension.location().toString());
        ListTag blocks = new ListTag();
        this.markedBlocks.forEach(block -> blocks.add((Object)NbtUtils.writeBlockPos((BlockPos)block)));
        nbt.put("blocks", (Tag)blocks);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.isValidArea = nbt.getBoolean("valid");
        this.areaType = AreaType.of(nbt.getString("type"));
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("dim")));
        ListTag markedBlocksNBT = (ListTag)nbt.get("blocks");
        if (markedBlocksNBT != null) {
            this.markedBlocks = new ArrayList<BlockPos>(this.areaType.maxBlocks);
            for (int i = 0; i < markedBlocksNBT.size(); ++i) {
                int[] intArray = markedBlocksNBT.getIntArray(i);
                IntArrayTag intArrayTag = new IntArrayTag(intArray);
                NbtCompatHelper.toBlockPos(intArrayTag).ifPresent(pos -> this.markedBlocks.add((BlockPos)pos));
            }
        }
    }
}

