/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FlagDetailMessage
implements MultiLineMessage<IFlag> {
    private final IProtectedRegion region;
    private final IFlag flag;
    private final List<Component> regionInfoLines;

    public FlagDetailMessage(IProtectedRegion region, IFlag flag) {
        this.region = region;
        this.flag = flag;
        this.regionInfoLines = new ArrayList<Component>();
    }

    @Override
    public IFlag getContent() {
        return this.flag;
    }

    @Override
    public List<Component> getLines() {
        this.regionInfoLines.clear();
        MutableComponent header = ChatComponentBuilder.buildFlagInfoHeader(this.region, this.flag);
        this.regionInfoLines.add((Component)header);
        MutableComponent state = ChatComponentBuilder.buildInfoComponent("cli.flag.state", "State", ChatComponentBuilder.buildFlagStateComponent(this.region, this.flag));
        MutableComponent override = ChatComponentBuilder.buildInfoComponent("cli.flag.override", "Override", ChatLinkBuilder.buildFlagOverrideToggleLink(this.region, this.flag, false));
        this.regionInfoLines.add((Component)state);
        this.regionInfoLines.add((Component)override);
        if (RegionFlag.hasPlayerCategory(this.flag)) {
            MutableComponent alert = ChatComponentBuilder.buildInfoComponent("cli.flag.msg.mute", "Alert", ChatLinkBuilder.buildFlagMuteToggleLink(this.region, this.flag, false));
            MutableComponent message = ChatComponentBuilder.buildInfoComponent("cli.flag.msg.text", "Message", ChatComponentBuilder.buildFlagMessageComponent(this.region, this.flag));
            this.regionInfoLines.add((Component)alert);
            this.regionInfoLines.add((Component)message);
        }
        return this.regionInfoLines;
    }
}

