/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands.arguments.region;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.data.region.RegionDataManager;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RegionArgumentType
implements ArgumentType<String> {
    public static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[A-Za-z]+[A-Za-z\\d\\-]+[A-Za-z\\d]+$");
    private static final Collection<String> EXAMPLES = Stream.of("spawn", "arena4pvp", "shop", "nether-hub").collect(Collectors.toSet());
    private static final SimpleCommandExceptionType ERROR_AREA_INVALID = new SimpleCommandExceptionType((Message)Component.translatableWithFallback((String)"cli.arg.region.parse.invalid", (String)"Unable to parse region name!"));
    private static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(flag -> Component.translatableWithFallback((String)"cli.arg.region.invalid", (String)"Region '%s' does not exist", (Object[])new Object[]{flag}));
    private static final DynamicCommandExceptionType ERROR_INVALID_LEVEL = new DynamicCommandExceptionType(flag -> Component.translatableWithFallback((String)"cli.arg.region.invalid", (String)"Unable to find dimension data", (Object[])new Object[]{flag}));

    public static <S> RegionType getRegionType(CommandContext<S> context) {
        String baseCmd;
        List nodes = context.getNodes();
        if (nodes.size() >= 2 && (baseCmd = ((ParsedCommandNode)nodes.get(0)).getNode().getName()).equals("yawp")) {
            boolean isFlagSubCmd;
            String regionTypeLiteral = ((ParsedCommandNode)nodes.get(1)).getNode().getName();
            RegionType regionType = RegionType.of(regionTypeLiteral);
            boolean bl = isFlagSubCmd = regionTypeLiteral.equals(CommandConstants.FLAG.toString()) && nodes.size() >= 3;
            if (isFlagSubCmd && regionType == null) {
                String flagRegionTypeLiteral = ((ParsedCommandNode)nodes.get(2)).getNode().getName();
                return RegionType.of(flagRegionTypeLiteral);
            }
            if (!isFlagSubCmd && regionType != null) {
                return regionType;
            }
        }
        return null;
    }

    public static IMarkableRegion getRegionIn(CommandContext<CommandSourceStack> context, String argName, Level level) throws CommandSyntaxException {
        String regionName = (String)context.getArgument(argName, String.class);
        Optional<LevelRegionData> dimensionCache = RegionManager.get().getLevelRegionData((ResourceKey<Level>)level.dimension());
        if (dimensionCache.isPresent()) {
            LevelRegionData dimCache = dimensionCache.get();
            if (!dimCache.hasLocal(regionName)) {
                MessageSender.sendCmdFeedback((CommandSourceStack)context.getSource(), Component.literal((String)("No region with name '" + regionName + "' defined in dim '" + dimCache.getDim().getName() + "'")));
                throw ERROR_INVALID_VALUE.create((Object)regionName);
            }
            IMarkableRegion region = dimCache.getLocal(regionName);
            if (region != null) {
                return region;
            }
            MessageSender.sendCmdFeedback((CommandSourceStack)context.getSource(), Component.literal((String)("No regions defined in dim '" + dimCache.getDim().getName() + "'")));
            throw ERROR_INVALID_VALUE.create((Object)regionName);
        }
        throw ERROR_INVALID_LEVEL.create((Object)level.dimension().location().toString());
    }

    public static IMarkableRegion getRegion(CommandContext<CommandSourceStack> context, String argName) throws CommandSyntaxException {
        String regionName = (String)context.getArgument(argName, String.class);
        LevelRegionData levelData = ArgumentUtil.getLevelDataArgument(context);
        if (!levelData.hasLocal(regionName)) {
            MessageSender.sendCmdFeedback((CommandSourceStack)context.getSource(), Component.literal((String)("No region with name '" + regionName + "' defined in dim '" + levelData.getDim().getName() + "'")));
            throw ERROR_INVALID_VALUE.create((Object)regionName);
        }
        IMarkableRegion region = levelData.getLocal(regionName);
        if (region != null) {
            return region;
        }
        MessageSender.sendCmdFeedback((CommandSourceStack)context.getSource(), Component.literal((String)("No regions defined in dim '" + levelData.getDim().getName() + "'")));
        throw ERROR_INVALID_VALUE.create((Object)regionName);
    }

    public static IProtectedRegion getRegion(CommandContext<CommandSourceStack> ctx, RegionType regionType) throws CommandSyntaxException {
        switch (regionType) {
            case GLOBAL: {
                return RegionManager.get().getGlobalRegion();
            }
            case DIMENSION: {
                LevelRegionData dimCache = ArgumentUtil.getLevelDataArgument(ctx);
                return dimCache.getDim();
            }
            case LOCAL: {
                LevelRegionData dimCache = ArgumentUtil.getLevelDataArgument(ctx);
                String regionName = (String)ctx.getArgument(CommandConstants.LOCAL.toString(), String.class);
                if (!dimCache.hasLocal(regionName)) {
                    MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.literal((String)("No region with name '" + regionName + "' defined in dim '" + dimCache.getDim().getName() + "'")));
                    throw ERROR_INVALID_VALUE.create((Object)regionName);
                }
                IMarkableRegion region = dimCache.getLocal(regionName);
                if (region != null) {
                    return region;
                }
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.literal((String)("No regions defined in dim '" + dimCache.getDim().getName() + "'")));
                throw ERROR_INVALID_VALUE.create((Object)regionName);
            }
        }
        throw ERROR_INVALID_VALUE.create((Object)"");
    }

    public static IProtectedRegion getTargetRegion(CommandContext<CommandSourceStack> ctx, String argName) throws CommandSyntaxException {
        String regionName = (String)ctx.getArgument(argName, String.class);
        LevelRegionData dimCache = ArgumentUtil.getTargetDimRegionArgument(ctx);
        if (!dimCache.hasLocal(regionName)) {
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.literal((String)("No region with name '" + regionName + "' defined in dim '" + dimCache.getDim().getName() + "'")));
            throw ERROR_INVALID_VALUE.create((Object)regionName);
        }
        IMarkableRegion region = dimCache.getLocal(regionName);
        if (region != null) {
            return region;
        }
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.literal((String)("No regions defined in dim '" + dimCache.getDim().getName() + "'")));
        throw ERROR_INVALID_VALUE.create((Object)regionName);
    }

    public static RegionArgumentType region() {
        return new RegionArgumentType();
    }

    public static IMarkableRegion getRegionInPlayerDim(CommandContext<CommandSourceStack> ctx, String argName) throws CommandSyntaxException {
        String regionName = (String)ctx.getArgument(argName, String.class);
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        LevelRegionData dimCache = RegionDataManager.getOrCreate((Level)player.level());
        IMarkableRegion region = dimCache.getLocal(regionName);
        if (region != null) {
            return region;
        }
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.literal((String)("No regions defined in dim '" + String.valueOf(dimCache.getDim().getDim().location()) + "'")));
        throw ERROR_INVALID_VALUE.create((Object)regionName);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && String.valueOf(reader.peek()).matches(Pattern.compile("^[A-Za-z\\d\\-]$").pattern())) {
            reader.skip();
        }
        String s = reader.getString().substring(i, reader.getCursor());
        try {
            boolean isValidName = s.matches(VALID_NAME_PATTERN.pattern());
            if (isValidName) {
                return s;
            }
            throw new IllegalArgumentException("Invalid region name supplied");
        }
        catch (IllegalArgumentException argumentException) {
            reader.setCursor(i);
            Constants.LOGGER.error("Error parsing region name");
            throw ERROR_AREA_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> ctx, SuggestionsBuilder builder) {
        Object object = ctx.getSource();
        if (object instanceof CommandSourceStack) {
            CommandSourceStack src = (CommandSourceStack)object;
            LevelRegionData dimCache = ArgumentUtil.getLevelDataArgument(ctx);
            return this.suggestRegionsForOwner(builder, src, dimCache);
        }
        return Suggestions.empty();
    }

    public <S> CompletableFuture<Suggestions> listSuggestionsIn(CommandContext<S> ctx, SuggestionsBuilder builder, Level level) {
        Object object = ctx.getSource();
        if (object instanceof CommandSourceStack) {
            CommandSourceStack src = (CommandSourceStack)object;
            Optional<LevelRegionData> dimensionCache = RegionManager.get().getLevelRegionData((ResourceKey<Level>)level.dimension());
            if (dimensionCache.isPresent()) {
                return this.suggestRegionsForOwner(builder, src, dimensionCache.get());
            }
            return Suggestions.empty();
        }
        return Suggestions.empty();
    }

    private CompletableFuture<Suggestions> suggestRegionsForOwner(SuggestionsBuilder builder, CommandSourceStack src, LevelRegionData dimCache) {
        Collection regions = dimCache.getLocalList();
        boolean hasPermission = Permissions.get().hasCmdPermission(src);
        if (hasPermission) {
            Collection<String> regionNames = dimCache.getLocalNames();
            if (regionNames.isEmpty()) {
                MessageSender.sendCmdFeedback(src, Component.literal((String)("No regions defined in dim '" + dimCache.getDim().getName() + "'")));
                return Suggestions.empty();
            }
            return SharedSuggestionProvider.suggest(regionNames, (SuggestionsBuilder)builder);
        }
        Entity entity = src.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Collection regionNames = (regions = (Collection)regions.stream().filter(region -> Permissions.get().hasOwnerPermission((IProtectedRegion)region, player)).collect(Collectors.toList())).stream().map(IProtectedRegion::getName).collect(Collectors.toSet());
            if (regionNames.isEmpty()) {
                MessageSender.sendCmdFeedback(src, Component.literal((String)("No regions defined in dim '" + dimCache.getDim().getName() + "'")));
                return Suggestions.empty();
            }
            return SharedSuggestionProvider.suggest((Iterable)regionNames, (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    public <S> CompletableFuture<Suggestions> listRegionsInTargetDim(CommandContext<S> ctx, SuggestionsBuilder builder) {
        Object object = ctx.getSource();
        if (object instanceof CommandSourceStack) {
            CommandSourceStack src = (CommandSourceStack)object;
            try {
                LevelRegionData dimCache = ArgumentUtil.getTargetDimRegionArgument(ctx);
                return this.suggestRegionsForOwner(builder, src, dimCache);
            }
            catch (CommandSyntaxException e) {
                return Suggestions.empty();
            }
        }
        return Suggestions.empty();
    }
}

