/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.handler.flags;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.api.events.region.FlagCheckResult;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;

@EventBusSubscriber(modid="yawp")
public class EntityFlagHandler {
    private EntityFlagHandler() {
    }

    @SubscribeEvent
    public static void onEnderTeleportTo(EntityTeleportEvent.EnderEntity event) {
        if (HandlerUtil.isServerSide(event.getEntity())) {
            FlagCheckEvent checkEvent;
            ResourceKey<Level> dim = HandlerUtil.getDimKey(event.getEntity());
            BlockPos target = new BlockPos((int)event.getPrev().x, (int)event.getPrev().y, (int)event.getPrev().z);
            if (event.getEntityLiving() instanceof EnderMan) {
                checkEvent = new FlagCheckEvent(target, RegionFlag.ENDERMAN_TELEPORT_FROM_REGION, dim);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, denyResult -> event.setCanceled(true));
            }
            if (event.getEntityLiving() instanceof Shulker) {
                checkEvent = new FlagCheckEvent(target, RegionFlag.SHULKER_TELEPORT_FROM_REGION, dim);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, denyResult -> event.setCanceled(true));
            }
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (HandlerUtil.isServerSide((Entity)event.getEntity())) {
            Player player;
            LivingEntity entity = event.getEntity();
            ResourceKey<Level> dim = HandlerUtil.getDimKey((Entity)event.getEntity());
            BlockPos target = entity.blockPosition();
            Consumer<FlagCheckResult> preventFallDmg = denyResult -> {
                event.setCanceled(true);
                event.setDistance(0.0);
                event.setDamageMultiplier(0.0f);
            };
            FlagCheckEvent checkEvent = new FlagCheckEvent(target, RegionFlag.FALL_DAMAGE, dim, entity instanceof Player ? (Player)entity : null);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, preventFallDmg);
            if (flagState == FlagState.DENIED) {
                return;
            }
            if (entity instanceof Player && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.FALL_DAMAGE_PLAYERS, dim, player = (Player)entity))) {
                return;
            }
            if (HandlerUtil.isVillager((Entity)entity) && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.FALL_DAMAGE_VILLAGERS, dim))) {
                return;
            }
            if (HandlerUtil.isAnimal((Entity)entity) && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.FALL_DAMAGE_ANIMALS, dim))) {
                return;
            }
            if (HandlerUtil.isMonster((Entity)entity) && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.FALL_DAMAGE_MONSTERS, dim))) {
                return;
            }
            if (checkEvent != null) {
                FlagEvaluator.processCheck(checkEvent, preventFallDmg);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (HandlerUtil.isServerSide(event.getLevel())) {
            Entity entity = event.getEntity();
            ResourceKey<Level> dim = HandlerUtil.getDimKey(event.getEntity());
            BlockPos target = entity.blockPosition();
            Consumer<FlagCheckResult> onDenyHandler = denyResult -> event.setCanceled(true);
            FlagCheckEvent checkEvent = null;
            if (entity instanceof Mob) {
                checkEvent = new FlagCheckEvent(target, RegionFlag.SPAWNING_ALL, dim);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagState flagState = FlagEvaluator.processCheck(checkEvent, onDenyHandler);
                if (flagState == FlagState.DENIED) {
                    return;
                }
            }
            if (HandlerUtil.isAnimal(entity) && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.SPAWNING_ANIMAL, dim))) {
                return;
            }
            if (HandlerUtil.isMonster(entity) && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.SPAWNING_MONSTER, dim))) {
                return;
            }
            if ((entity instanceof SnowGolem || entity instanceof IronGolem) && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.SPAWNING_GOLEM, dim))) {
                return;
            }
            if (entity instanceof Villager && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.SPAWNING_VILLAGER, dim))) {
                return;
            }
            if (entity instanceof WanderingTrader && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.SPAWNING_TRADER, dim))) {
                return;
            }
            if (entity instanceof Slime && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.SPAWNING_SLIME, dim))) {
                return;
            }
            if (entity instanceof ExperienceOrb && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.SPAWNING_XP, dim))) {
                return;
            }
            if (checkEvent != null) {
                FlagEvaluator.processCheck(checkEvent, onDenyHandler);
            }
        }
    }
}

