/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class RegionStateMessage
implements MultiLineMessage<IProtectedRegion> {
    private final IProtectedRegion region;
    private final List<Component> regionState;

    public RegionStateMessage(IProtectedRegion region) {
        this.region = region;
        this.regionState = new ArrayList<Component>();
    }

    public static RegionStateMessage of(IProtectedRegion region) {
        return new RegionStateMessage(region);
    }

    public static MutableComponent buildRegionStateLink(IProtectedRegion region) {
        MutableComponent linkText = Component.translatableWithFallback((String)"cli.msg.info.region.state.link.text", (String)"State");
        MutableComponent hoverText = Component.translatableWithFallback((String)"cli.msg.info.region.state.link.hover", (String)"Show region state for %s", (Object[])new Object[]{region.getName()});
        String cmd = Commands.buildRegionStateCmd(region);
        return ChatComponentBuilder.buildExecuteCmdLink(linkText, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildRegionRenameLink(IMarkableRegion region) {
        String cmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().location().toString(), region.getName(), CommandConstants.RENAME.toString(), "");
        MutableComponent text = Component.translatableWithFallback((String)"cli.msg.info.region.state.rename.link.text", (String)"rename");
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.state.rename.link.hover", (String)"Rename region '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLink(text, hover, cmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
    }

    public static MutableComponent buildRegionPriorityComponent(IMarkableRegion region) {
        int defaultPriorityInc = Services.REGION_CONFIG.getDefaultPriorityInc();
        String incPriorityCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().location().toString(), region.getName(), CommandConstants.STATE.toString(), CommandConstants.PRIORITY.toString(), CommandConstants.INC.toString(), String.valueOf(defaultPriorityInc));
        MutableComponent incLinkText = Component.translatableWithFallback((String)"cli.msg.info.region.state.priority.increase.link.text", (String)"+%s", (Object[])new Object[]{defaultPriorityInc});
        MutableComponent incHoverText = Component.translatableWithFallback((String)"cli.msg.info.region.state.priority.increase.link.hover", (String)"Increase region priority by %s", (Object[])new Object[]{defaultPriorityInc});
        MutableComponent increaseLink = ChatComponentBuilder.buildExecuteCmdComponent(incLinkText, incHoverText, incPriorityCmd, ClickEvent.Action.RUN_COMMAND, Messages.ADD_CMD_COLOR);
        String decPriorityCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().location().toString(), region.getName(), CommandConstants.STATE.toString(), CommandConstants.PRIORITY.toString(), CommandConstants.DEC.toString(), String.valueOf(defaultPriorityInc));
        MutableComponent decLinkText = Component.translatableWithFallback((String)"cli.msg.info.region.state.priority.decrease.link.text", (String)"+%s", (Object[])new Object[]{defaultPriorityInc});
        MutableComponent decHoverText = Component.translatableWithFallback((String)"cli.msg.info.region.state.priority.decrease.link.hover", (String)"Decrease region priority by %s", (Object[])new Object[]{defaultPriorityInc});
        MutableComponent decreaseLink = ChatComponentBuilder.buildExecuteCmdComponent(decLinkText, decHoverText, decPriorityCmd, ClickEvent.Action.RUN_COMMAND, Messages.REMOVE_CMD_COLOR);
        String setPriorityCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().location().toString(), region.getName(), CommandConstants.STATE.toString(), CommandConstants.PRIORITY.toString(), "");
        MutableComponent setPriorityLinkText = Component.translatableWithFallback((String)"cli.msg.info.region.state.priority.set.link.text", (String)"%s", (Object[])new Object[]{region.getPriority()});
        MutableComponent setPriorityHoverText = Component.translatableWithFallback((String)"cli.msg.info.region.state.priority.set.link.hover", (String)"Set priority for region");
        MutableComponent setPriorityLink = ChatComponentBuilder.buildExecuteCmdComponent(setPriorityLinkText, setPriorityHoverText, setPriorityCmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
        return Messages.substitutable("%s %s %s", setPriorityLink, increaseLink, decreaseLink);
    }

    public static MutableComponent buildAllLocalAlertToggleLink(IProtectedRegion dimRegion) {
        MutableComponent enableLinkTextKey = Component.translatableWithFallback((String)"cli.msg.info.region.state.enable.all.true.link.text", (String)"all-on");
        MutableComponent enableHoverTextKey = Component.translatableWithFallback((String)"cli.msg.info.region.state.enable.all.true.link.hover", (String)"Enables alert for all local regions of %s", (Object[])new Object[]{dimRegion.getName()});
        MutableComponent disableLinkTextKey = Component.translatableWithFallback((String)"cli.msg.info.region.state.enable.all.false.link.text", (String)"all-off");
        MutableComponent disableHoverTextKey = Component.translatableWithFallback((String)"cli.msg.info.region.state.enable.all.false.link.hover", (String)"Disables alert for all local regions of %s", (Object[])new Object[]{dimRegion.getName()});
        String enableCmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), dimRegion.getName(), CommandConstants.STATE.toString(), CommandConstants.ALERT_LOCAL.toString(), Boolean.TRUE.toString());
        String disableCmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), dimRegion.getName(), CommandConstants.STATE.toString(), CommandConstants.ALERT_LOCAL.toString(), Boolean.FALSE.toString());
        MutableComponent activeAlertLink = ChatComponentBuilder.buildExecuteCmdComponent(enableLinkTextKey, enableHoverTextKey, enableCmd, ClickEvent.Action.RUN_COMMAND, ChatFormatting.GREEN);
        MutableComponent disableAlertLink = ChatComponentBuilder.buildExecuteCmdComponent(disableLinkTextKey, disableHoverTextKey, disableCmd, ClickEvent.Action.RUN_COMMAND, ChatFormatting.RED);
        return Messages.substitutable("%s %s", activeAlertLink, disableAlertLink);
    }

    public static MutableComponent buildAllLocalEnableComponent(IProtectedRegion dimRegion) {
        MutableComponent enableLinkTextKey = Component.translatableWithFallback((String)"cli.msg.info.region.state.alert.all.true.link.text", (String)"all-on");
        MutableComponent enableHoverTextKey = Component.translatableWithFallback((String)"cli.msg.info.region.state.alert.all.true.link.hover", (String)"Activates all local regions of %s", (Object[])new Object[]{dimRegion.getName()});
        MutableComponent disableLinkTextKey = Component.translatableWithFallback((String)"cli.msg.info.region.state.alert.all.false.link.text", (String)"all-off");
        MutableComponent disableHoverTextKey = Component.translatableWithFallback((String)"cli.msg.info.region.state.alert.all.false.link.hover", (String)"Disables all local regions of %s", (Object[])new Object[]{dimRegion.getName()});
        String enableCmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), dimRegion.getName(), CommandConstants.STATE.toString(), CommandConstants.ENABLE_LOCAL.toString(), Boolean.TRUE.toString());
        String disableCmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), dimRegion.getName(), CommandConstants.STATE.toString(), CommandConstants.ENABLE_LOCAL.toString(), Boolean.FALSE.toString());
        MutableComponent activeAlertLink = ChatComponentBuilder.buildExecuteCmdComponent(enableLinkTextKey, enableHoverTextKey, enableCmd, ClickEvent.Action.RUN_COMMAND, ChatFormatting.GREEN);
        MutableComponent disableAlertLink = ChatComponentBuilder.buildExecuteCmdComponent(disableLinkTextKey, disableHoverTextKey, disableCmd, ClickEvent.Action.RUN_COMMAND, ChatFormatting.RED);
        return Messages.substitutable("%s %s", activeAlertLink, disableAlertLink);
    }

    public static MutableComponent buildRegionEnableComponent(IProtectedRegion region) {
        String linkTextKey = "cli.msg.info.region.state.enable." + region.isActive() + ".link.text";
        String linkFallback = region.isActive() ? "yes" : "no";
        String hoverTextKey = "cli.msg.info.region.state.enable." + !region.isActive() + ".link.hover";
        String hoverFallback = !region.isActive() ? "Enable flag checks" : "Disable flag checks";
        MutableComponent linkText = Component.translatableWithFallback((String)linkTextKey, (String)linkFallback);
        MutableComponent hoverText = Component.translatableWithFallback((String)hoverTextKey, (String)hoverFallback);
        ChatFormatting color = region.isActive() ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        String cmd = Commands.buildRegionStateEnableToggleCmd(region);
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, color);
    }

    public static MutableComponent buildRegionAlertToggleLink(IProtectedRegion region) {
        String linkTextKey = "cli.msg.info.region.state.alert." + !region.isMuted() + ".link.text";
        String hoverTextKey = "cli.msg.info.region.state.alert." + region.isMuted() + ".link.hover";
        String linkFallback = region.isMuted() ? "off" : "on";
        String hoverFallback = !region.isMuted() ? "Turn flag alerts off" : "Turn flag alerts on";
        MutableComponent linkText = Component.translatableWithFallback((String)linkTextKey, (String)linkFallback);
        MutableComponent hoverText = Component.translatableWithFallback((String)hoverTextKey, (String)hoverFallback);
        ChatFormatting color = region.isMuted() ? ChatFormatting.GRAY : ChatFormatting.GREEN;
        String cmd = Commands.buildRegionStateAlertToggleCmd(region);
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, color);
    }

    @Override
    public IProtectedRegion getContent() {
        return this.region;
    }

    @Override
    public List<Component> getLines() {
        MutableComponent header = ChatComponentBuilder.buildHeader(Component.translatableWithFallback((String)"cli.msg.info.header.for", (String)"== %s for %s ==", (Object[])new Object[]{RegionStateMessage.buildRegionStateLink(this.region), ChatLinkBuilder.buildRegionInfoLink(this.region)}));
        this.regionState.add((Component)header);
        MutableComponent regionEnableComponent = RegionStateMessage.buildRegionEnableComponent(this.region);
        MutableComponent regionAlertComponent = RegionStateMessage.buildRegionAlertToggleLink(this.region);
        if (this.region.getRegionType() == RegionType.DIMENSION) {
            MutableComponent enableComp = Messages.substitutable("%s | %s", regionEnableComponent, RegionStateMessage.buildAllLocalEnableComponent(this.region));
            MutableComponent alertComp = Messages.substitutable("%s | %s", regionAlertComponent, RegionStateMessage.buildAllLocalAlertToggleLink(this.region));
            this.regionState.add((Component)ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state.enable", "Enabled", enableComp));
            this.regionState.add((Component)ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state.alert", "Alert", alertComp));
            return this.regionState;
        }
        if (this.region.getRegionType() == RegionType.LOCAL) {
            IMarkableRegion localRegion = (IMarkableRegion)this.region;
            MutableComponent name = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state.name", "Name", RegionStateMessage.buildRegionRenameLink(localRegion));
            MutableComponent priority = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state.priority", "Priority", RegionStateMessage.buildRegionPriorityComponent(localRegion));
            this.regionState.add((Component)name);
            this.regionState.add((Component)priority);
        }
        MutableComponent enableComp = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state.enable", "Enabled", regionEnableComponent);
        MutableComponent alertComp = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.state.alert", "Alert", regionAlertComponent);
        this.regionState.add((Component)Messages.substitutable("%s, %s", enableComp, alertComp));
        return this.regionState;
    }
}

