/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.pagination.BasePaginationMessage;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class RegionFlagPagination
extends BasePaginationMessage<IFlag> {
    private final IProtectedRegion region;

    public RegionFlagPagination(IProtectedRegion region, int pageNumber, int pageSize) throws InvalidPageNumberException {
        super(region.getFlags().flags(), Commands.buildListRegionFlagsCommand(region), pageNumber, pageSize);
        this.region = region;
    }

    public static MutableComponent buildRegionFlagInfoHeader(IProtectedRegion region, MutableComponent flagListLink) {
        return ChatComponentBuilder.buildHeader(Component.translatableWithFallback((String)"cli.msg.info.header.in", (String)"== %s in %s ==", (Object[])new Object[]{flagListLink, ChatLinkBuilder.buildRegionInfoLink(region)}));
    }

    public static List<Component> buildRegionFlagEntries(IProtectedRegion region) {
        return RegionFlagPagination.buildRegionFlagEntries(region, region.getFlags().flags());
    }

    public static List<Component> buildRegionFlagEntries(IProtectedRegion region, List<IFlag> selectedFlags) {
        ArrayList<Component> flagEntries = new ArrayList<Component>();
        flagEntries.addAll(RegionFlagPagination.buildFlagEntriesForState(region, selectedFlags, FlagState.DENIED));
        flagEntries.addAll(RegionFlagPagination.buildFlagEntriesForState(region, selectedFlags, FlagState.ALLOWED));
        flagEntries.addAll(RegionFlagPagination.buildFlagEntriesForState(region, selectedFlags, FlagState.DISABLED));
        return flagEntries;
    }

    public static List<MutableComponent> buildFlagEntriesForState(IProtectedRegion region, List<IFlag> selectedFlags, FlagState state) {
        List<IFlag> flagsByState = selectedFlags.stream().filter(f -> f.getState() == state).sorted(Comparator.comparing(IFlag::getName)).toList();
        return flagsByState.stream().map(flag -> RegionFlagPagination.buildRemoveFlagEntry(region, flag, RegionFlagPagination.colorForState(flag.getState()), new ChatFormatting[0])).collect(Collectors.toList());
    }

    public static MutableComponent buildRemoveFlagEntry(IProtectedRegion region, IFlag flag, ChatFormatting flagLinkColor, ChatFormatting ... ChatFormattings) {
        String cmd = switch (region.getRegionType()) {
            case RegionType.GLOBAL -> Commands.buildCommandStr(CommandConstants.GLOBAL.toString(), CommandConstants.REMOVE.toString(), CommandConstants.FLAG.toString(), flag.getName());
            case RegionType.DIMENSION -> Commands.buildCommandStr(CommandConstants.DIM.toString(), region.getDim().location().toString(), CommandConstants.REMOVE.toString(), CommandConstants.FLAG.toString(), flag.getName());
            case RegionType.LOCAL -> Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().location().toString(), region.getName(), CommandConstants.REMOVE.toString(), CommandConstants.FLAG.toString(), flag.getName());
            default -> throw new IllegalArgumentException();
        };
        MutableComponent hoverText = Component.translatableWithFallback((String)"cli.msg.info.region.flag.remove.link.hover", (String)"Remove flag '%s' from region %s", (Object[])new Object[]{flag.getName(), region.getName()});
        MutableComponent linkText = Component.translatableWithFallback((String)"cli.link.remove", (String)"x");
        MutableComponent flagRemoveLink = ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, Messages.REMOVE_CMD_COLOR);
        MutableComponent flagQuickActionComponent = RegionFlagPagination.buildFlagQuickActionComponent(region, flag, flagLinkColor);
        flagQuickActionComponent.withStyle(ChatFormattings);
        return Messages.substitutable(" - %s %s", flagRemoveLink, flagQuickActionComponent);
    }

    public static ChatFormatting colorForState(FlagState state) {
        switch (state) {
            case ALLOWED: {
                return ChatFormatting.GREEN;
            }
            case DENIED: {
                return ChatFormatting.RED;
            }
            case DISABLED: {
                return ChatFormatting.GRAY;
            }
        }
        throw new IllegalArgumentException();
    }

    public static MutableComponent buildFlagQuickActionComponent(IProtectedRegion region, IFlag flag, ChatFormatting flagLinkColor) {
        MutableComponent regionTypeIndicator = Component.literal((String)region.getRegionType().type.substring(0, 1).toUpperCase());
        MutableComponent hoverText = Component.translatableWithFallback((String)"cli.flag.info.hover", (String)"Show %s flag info of region '%s'", (Object[])new Object[]{flag.getName(), region.getName()});
        MutableComponent flagInfoLink = ChatLinkBuilder.buildFlagInfoLink(region, flag, flagLinkColor);
        return Messages.substitutable("%s %s %s %s %s", flagInfoLink, ChatLinkBuilder.buildFlagInfoLink(region, flag, regionTypeIndicator, hoverText, ChatFormatting.DARK_PURPLE), ChatLinkBuilder.buildFlagStateSuggestionLink(region, flag), ChatLinkBuilder.buildFlagMuteToggleLink(region, flag, true), ChatLinkBuilder.buildFlagOverrideToggleLink(region, flag, true));
    }

    @Override
    public Component noContentMsg() {
        return Component.translatableWithFallback((String)"cli.msg.info.region.flag.empty", (String)"No flags defined in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(this.region)});
    }

    @Override
    public Component header() {
        return RegionFlagPagination.buildRegionFlagInfoHeader(this.region, ChatLinkBuilder.buildRegionFlagListLink(this.region));
    }

    @Override
    public List<Component> buildEntries() {
        return RegionFlagPagination.buildRegionFlagEntries(this.region, this.pageContent);
    }

    @Override
    public Component emptyEntry() {
        return Messages.substitutable(" - %s", ChatLinkBuilder.buildSuggestAddFlagLink(this.region));
    }
}

