/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.visualization;

import de.z0rdak.yawp.util.visualization.BlockDisplayProperty;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class RegionOutlineBuilder {
    public static Set<Entity> buildAreaDisplaySet(ServerLevel level, Set<BlockPos> frame, CompoundTag blockDisplayTag) {
        return frame.stream().map(blockPos -> RegionOutlineBuilder.buildBlockDisplay(level, blockPos, blockDisplayTag)).collect(Collectors.toSet());
    }

    public static Entity buildBlockDisplay(ServerLevel level, BlockPos pos, CompoundTag displayTag) {
        displayTag.putString("id", EntityType.BLOCK_DISPLAY.builtInRegistryHolder().key().location().toString());
        return EntityType.loadEntityRecursive((CompoundTag)displayTag, (Level)level, (EntitySpawnReason)EntitySpawnReason.COMMAND, p_396566_ -> {
            p_396566_.snapTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), p_396566_.getYRot(), p_396566_.getXRot());
            return p_396566_;
        });
    }

    public static CompoundTag buildBlockDisplayTag(BlockDisplayProperty properties) {
        CompoundTag blockDisplayTag = new CompoundTag();
        blockDisplayTag.putBoolean("Glowing", properties.glowing());
        CompoundTag blockstateTag = new CompoundTag();
        blockstateTag.putString("Name", properties.blockName());
        blockDisplayTag.put("block_state", (Tag)blockstateTag);
        CompoundTag brightnessTag = new CompoundTag();
        brightnessTag.putInt("sky", 15);
        brightnessTag.putInt("block", 15);
        blockDisplayTag.put("brightness", (Tag)brightnessTag);
        return blockDisplayTag;
    }
}

