package de.z0rdak.yawp.util.text.messages.pagination;

import static de.z0rdak.yawp.util.ChatComponentBuilder.buildExecuteCmdComponent;
import static de.z0rdak.yawp.util.text.Messages.INACTIVE_LINK_COLOR;
import static de.z0rdak.yawp.util.text.Messages.LINK_COLOR;
import static net.minecraft.class_2558.class_2559.field_11750;

import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_5250;

// Note: Maybe extend with Builder-Pattern to customize lang keys, link color, page indicator, etc.
public record PaginationLinks(String command, int pageNumber, int pageSize, int numberOfPages) {


    public static int FIRST_PAGE_IDX = 0;

    public String buildPageCommand(String cmd, int page) {
        return String.join(" ", cmd, Integer.toString(page));
    }

    public class_5250 buildLastLinkArrow(String cmd, int pageNo, int numberOfPages, boolean hasMultiplePages) {
        class_5250 last = class_2561.method_48321("cli.msg.info.pagination.last.text", ">>");
        class_5250 lastHover = class_2561.method_48321("cli.msg.info.pagination.last.hover", "Last page");
        return hasMultiplePages && pageNo < numberOfPages - 1
                ? buildExecuteCmdComponent(last, lastHover, buildPageCommand(cmd, numberOfPages - 1), field_11750, LINK_COLOR)
                : class_2564.method_10885(last).method_27692(INACTIVE_LINK_COLOR);
    }

    public class_5250 buildNextLinkArrow(String cmd, int pageNo, int numberOfPages, boolean hasMultiplePages) {
        class_5250 next = class_2561.method_48321("cli.msg.info.pagination.next.text", ">");
        class_5250 nextHover = class_2561.method_48321("cli.msg.info.pagination.next.hover", "Next page");
        return hasMultiplePages && pageNo < numberOfPages - 1
                ? buildExecuteCmdComponent(next, nextHover, buildPageCommand(cmd, Math.min(pageNo + 1, numberOfPages - 1)), field_11750, LINK_COLOR)
                : class_2564.method_10885(next).method_27692(INACTIVE_LINK_COLOR);
    }

    public class_5250 buildPrevLinkArrow(String cmd, int pageNo, boolean hasMultiplePages) {
        class_5250 previous = class_2561.method_48321("cli.msg.info.pagination.previous.text", "<");
        class_5250 previousHover = class_2561.method_48321("cli.msg.info.pagination.previous.hover", "Previous page");
        return hasMultiplePages && pageNo > FIRST_PAGE_IDX
                ? buildExecuteCmdComponent(previous, previousHover, buildPageCommand(cmd, Math.max(pageNo - 1, FIRST_PAGE_IDX)), field_11750, LINK_COLOR)
                : class_2564.method_10885(previous).method_27692(INACTIVE_LINK_COLOR);
    }

    public class_5250 buildFirstLinkArrow(String cmd, int pageNo, boolean hasMultiplePages) {
        class_5250 first = class_2561.method_48321("cli.msg.info.pagination.first.text", "<<");
        class_5250 firstHover = class_2561.method_48321("cli.msg.info.pagination.first.hover", "First page");
        return hasMultiplePages && pageNo != FIRST_PAGE_IDX
                ? buildExecuteCmdComponent(first, firstHover, buildPageCommand(cmd, FIRST_PAGE_IDX), field_11750, LINK_COLOR)
                : class_2564.method_10885(first).method_27692(INACTIVE_LINK_COLOR);
    }

}
