/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.events.flag.FlagEvent;
import de.z0rdak.yawp.commands.CommandUtil;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.commands.arguments.flag.IFlagArgumentType;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.core.flag.FlagMessage;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

final class FlagCommands {
    private FlagCommands() {
    }

    static LiteralArgumentBuilder<class_2168> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.FLAG).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.GLOBAL).executes(ctx -> CommandUtil.promptRegionFlagList((CommandContext<class_2168>)ctx, ArgumentUtil.getGlobalRegion(), 0))).then(FlagCommands.flagSubCmd(ctx -> ArgumentUtil.getGlobalRegion())))).then(ArgumentUtil.literal(CommandConstants.DIM).then(FlagCommands.flagDimSubCommands()))).then(ArgumentUtil.literal(CommandConstants.LOCAL).then(FlagCommands.flagLocalSubCommands()));
    }

    private static RequiredArgumentBuilder<class_2168, class_2960> flagDimSubCommands() {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.DIM.toString(), (ArgumentType)class_2181.method_9288()).executes(ctx -> CommandUtil.promptRegionFlagList((CommandContext<class_2168>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<class_2168>)ctx).getDim(), 0))).then(FlagCommands.flagSubCmd(ctx -> ArgumentUtil.getLevelDataArgument((CommandContext<class_2168>)ctx).getDim()));
    }

    private static RequiredArgumentBuilder<class_2168, class_2960> flagLocalSubCommands() {
        return (RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.DIM.toString(), (ArgumentType)class_2181.method_9288()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestions(ctx, builder)).executes(ctx -> CommandUtil.promptRegionFlagList((CommandContext<class_2168>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<class_2168>)ctx).getDim(), 0))).then(FlagCommands.flagSubCmd(ArgumentUtil::getRegionArgument)));
    }

    private static RequiredArgumentBuilder<class_2168, String> flagSubCmd(Function<CommandContext<class_2168>, IProtectedRegion> regionSupplier) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.FLAG.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> IFlagArgumentType.flag().listSuggestions(ctx, builder)).executes(ctx -> FlagCommands.promptFlagInfo((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<class_2168>)ctx)))).then(ArgumentUtil.literal(CommandConstants.INFO).executes(ctx -> FlagCommands.promptFlagInfo((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<class_2168>)ctx))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.STATE).executes(ctx -> FlagCommands.setFlagState((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<class_2168>)ctx)))).then(class_2170.method_9244((String)CommandConstants.STATE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(FlagState.ValidFlagStates(), (SuggestionsBuilder)builder)).executes(ctx -> FlagCommands.setFlagState((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getFlagStateArgument((CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.OVERRIDE).executes(ctx -> FlagCommands.setOverride((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<class_2168>)ctx)))).then(class_2170.method_9244((String)CommandConstants.OVERRIDE.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> FlagCommands.setOverride((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getOverrideArgument((CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.MSG).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.MUTE).executes(ctx -> FlagCommands.setFlagMuteState((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<class_2168>)ctx)))).then(class_2170.method_9244((String)CommandConstants.MUTE.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> FlagCommands.setFlagMuteState((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<class_2168>)ctx), ArgumentUtil.muteArgument((CommandContext<class_2168>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.SET).then(class_2170.method_9244((String)CommandConstants.MSG.toString(), (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9265(FlagCommands.flagMsgExamples(), (SuggestionsBuilder)builder)).executes(ctx -> FlagCommands.setRegionFlagMsg((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getFlagMsgArgument((CommandContext<class_2168>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.CLEAR).executes(ctx -> FlagCommands.setRegionFlagMsg((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<class_2168>)ctx), "config"))));
    }

    private static List<String> flagMsgExamples() {
        int amountOfExamples = 10;
        ArrayList<String> examples = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            examples.add(class_2561.method_48321((String)("cli.flag.msg.text.example." + i), (String)"<Your flag message here>").getString());
        }
        return examples;
    }

    private static int promptFlagInfo(CommandContext<class_2168> ctx, IProtectedRegion region, IFlag flag) {
        if (flag == null) {
            return 1;
        }
        MultiLineMessage.send((class_2168)ctx.getSource(), MultiLineMessage.flagDetail(region, flag));
        return 0;
    }

    private static int setFlagMuteState(CommandContext<class_2168> ctx, IProtectedRegion region, IFlag regionFlag) {
        if (regionFlag == null) {
            return 1;
        }
        if (region.containsFlag(regionFlag.getName())) {
            IFlag flag;
            return FlagCommands.setFlagMuteState(ctx, region, flag, !(flag = region.getFlag(regionFlag.getName())).getFlagMsg().isMuted());
        }
        class_5250 hint = class_2561.method_48322((String)"cli.msg.info.region.flag.add-hint", (String)"Add flag by clicking: %s", (Object[])new Object[]{ChatLinkBuilder.buildSuggestAddFlagLink(region)});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.flag.not-present", (String)"Region %s does not contain flag '%s'. %", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), regionFlag.getName(), hint}));
        return 1;
    }

    private static int setFlagMuteState(CommandContext<class_2168> ctx, IProtectedRegion region, IFlag flag, boolean setMuted) {
        if (flag == null) {
            return 1;
        }
        flag.getFlagMsg().mute(setMuted);
        String muteState = flag.getFlagMsg().isMuted() ? "on" : "off";
        class_5250 infoMsg = class_2561.method_48322((String)"cli.flag.msg.mute.success.text", (String)"Set mute state of %s to: '%s'", (Object[])new Object[]{ChatLinkBuilder.buildFlagInfoLink(region, flag), muteState});
        class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), String.valueOf(!setMuted), String.valueOf(setMuted));
        class_5250 msg = Messages.substitutable("%s %s", infoMsg, undoLink);
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), msg);
        RegionManager.get().save();
        return 0;
    }

    private static int setRegionFlagMsg(CommandContext<class_2168> ctx, IProtectedRegion region, IFlag flag, String flagMsgStr) {
        if (flag == null) {
            return 1;
        }
        String oldFlagMsg = flag.getFlagMsg().msg();
        FlagEvent.UpdateFlagMessageEvent editMsgEvent = new FlagEvent.UpdateFlagMessageEvent((class_2168)ctx.getSource(), region, flag, flagMsgStr);
        Services.EVENT.post(editMsgEvent);
        FlagMessage flagMsg = new FlagMessage(flagMsgStr, flag.getFlagMsg().isMuted());
        flag.setFlagMsg(flagMsg);
        class_5250 infoMsg = class_2561.method_48322((String)"cli.flag.msg.msg.success.text", (String)"Set message of %s to: '%s'", (Object[])new Object[]{ChatLinkBuilder.buildFlagInfoLink(region, flag), flagMsgStr});
        class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), flagMsgStr, oldFlagMsg);
        class_5250 msg = Messages.substitutable("%s %s", infoMsg, undoLink);
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), msg);
        RegionManager.get().save();
        return 0;
    }

    private static int setFlagState(CommandContext<class_2168> ctx, IProtectedRegion region, IFlag regionFlag) {
        if (regionFlag == null) {
            return 1;
        }
        if (region.containsFlag(regionFlag.getName())) {
            IFlag flag = region.getFlag(regionFlag.getName());
            if (flag.getState() == FlagState.ALLOWED || flag.getState() == FlagState.DENIED) {
                return FlagCommands.setFlagState(ctx, region, regionFlag, FlagState.invert(flag.getState()));
            }
            if (flag.getState() == FlagState.DISABLED) {
                return FlagCommands.setFlagState(ctx, region, regionFlag, FlagState.DENIED);
            }
            return FlagCommands.setFlagState(ctx, region, regionFlag, flag.getState());
        }
        class_5250 hint = class_2561.method_48322((String)"cli.msg.info.region.flag.add-hint", (String)"Add flag by clicking: %s", (Object[])new Object[]{ChatLinkBuilder.buildSuggestAddFlagLink(region)});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.flag.not-present", (String)"Region %s does not contain flag '%s'. %", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), regionFlag.getName(), hint}));
        return 1;
    }

    private static int setFlagState(CommandContext<class_2168> ctx, IProtectedRegion region, IFlag flag, FlagState flagState) {
        if (flag == null) {
            return 1;
        }
        FlagState oldState = flag.getState();
        flag.setState(flagState);
        class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), flagState.name, oldState.name);
        class_5250 infoMsg = class_2561.method_48322((String)"cli.flag.state.success.text", (String)"Set flag state of %s to: '%s'", (Object[])new Object[]{ChatLinkBuilder.buildFlagInfoLink(region, flag), flag.getState().name});
        class_5250 msg = Messages.substitutable("%s %s", infoMsg, undoLink);
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), msg);
        RegionManager.get().save();
        return 0;
    }

    private static int setOverride(CommandContext<class_2168> ctx, IProtectedRegion region, IFlag regionFlag) {
        if (regionFlag == null) {
            return 1;
        }
        if (region.containsFlag(regionFlag.getName())) {
            IFlag flag;
            return FlagCommands.setOverride(ctx, region, flag, !(flag = region.getFlag(regionFlag.getName())).doesOverride());
        }
        class_5250 hint = class_2561.method_48322((String)"cli.msg.info.region.flag.add-hint", (String)"Add flag by clicking: %s", (Object[])new Object[]{ChatLinkBuilder.buildSuggestAddFlagLink(region)});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.flag.not-present", (String)"Region %s does not contain flag '%s'. %", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), regionFlag.getName(), hint}));
        return 1;
    }

    private static int setOverride(CommandContext<class_2168> ctx, IProtectedRegion region, IFlag flag, boolean override) {
        if (flag == null) {
            return 1;
        }
        flag.setOverride(override);
        String overrideState = flag.doesOverride() ? "on" : "off";
        class_5250 infoMsg = class_2561.method_48322((String)"cli.flag.override.success.text", (String)"Set flag override for %s to %s", (Object[])new Object[]{ChatLinkBuilder.buildFlagInfoLink(region, flag), overrideState});
        class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), String.valueOf(!override), String.valueOf(override));
        class_5250 msg = Messages.substitutable("%s %s", infoMsg, undoLink);
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), msg);
        RegionManager.get().save();
        return 0;
    }
}

