/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin.flag.player;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.config.server.FlagConfig;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3989;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin {
    @Inject(method={"drop"}, at={@At(value="HEAD")}, allow=1, cancellable=true)
    private void onDropItem(class_1799 stack, boolean includeThrowerName, CallbackInfoReturnable<class_1799> cir) {
        class_1657 player = (class_1657)this;
        if (HandlerUtil.isServerSide((class_1297)player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.ITEM_DROP, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                player.method_7270(stack);
                cir.setReturnValue(null);
            });
        }
    }

    @Inject(method={"giveExperienceLevels"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void onGainLevels(int levels, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (HandlerUtil.isServerSide((class_1297)player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.LEVEL_FREEZE, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                ci.cancel();
            });
        }
    }

    @Inject(method={"giveExperiencePoints"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void onGainExperience(int experience, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (HandlerUtil.isServerSide((class_1297)player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.XP_FREEZE, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                ci.cancel();
            });
        }
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F")}, cancellable=true, allow=1)
    public void onHurt(class_3218 level, class_1282 source, float amount, CallbackInfo ci) {
        class_1657 self = (class_1657)this;
        if (HandlerUtil.isServerSide((class_1297)self)) {
            FlagCheckEvent checkEvent;
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_1657) {
                class_1657 attackingPlayer = (class_1657)class_12972;
                FlagCheckEvent checkEvent2 = new FlagCheckEvent(self.method_24515(), RegionFlag.NO_PVP, HandlerUtil.getDimKey((class_1297)self), attackingPlayer);
                if (Services.EVENT.post(checkEvent2)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent2, deny -> {
                    MessageSender.sendFlagMsg(deny);
                    ci.cancel();
                });
            }
            if (Services.EVENT.post(checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.INVINCIBLE, HandlerUtil.getDimKey((class_1297)self), self))) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> ci.cancel());
        }
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;setAbsorptionAmount(F)V")}, cancellable=true, allow=1)
    public void onReceiveDamage(class_3218 level, class_1282 damageSource, float amount, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (HandlerUtil.isServerSide((class_1297)player)) {
            // empty if block
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void onAttackEntity(class_1297 target, CallbackInfo ci) {
        if (HandlerUtil.isServerSide(target)) {
            class_1657 player = (class_1657)this;
            if (target == null) {
                return;
            }
            if (target instanceof class_1657) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(target.method_24515(), RegionFlag.MELEE_PLAYERS, HandlerUtil.getDimKey((class_1297)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    MessageSender.sendFlagMsg(deny);
                    ci.cancel();
                });
            } else {
                FlagCheckEvent checkEvent;
                if (HandlerUtil.isAnimal(target)) {
                    checkEvent = new FlagCheckEvent(target.method_24515(), RegionFlag.MELEE_ANIMALS, HandlerUtil.getDimKey((class_1297)player), player);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, deny -> {
                        MessageSender.sendFlagMsg(deny);
                        ci.cancel();
                    });
                }
                if (HandlerUtil.isMonster(target)) {
                    checkEvent = new FlagCheckEvent(target.method_24515(), RegionFlag.MELEE_MONSTERS, HandlerUtil.getDimKey((class_1297)player), player);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, deny -> {
                        MessageSender.sendFlagMsg(deny);
                        ci.cancel();
                    });
                }
                if (target instanceof class_1646) {
                    checkEvent = new FlagCheckEvent(target.method_24515(), RegionFlag.MELEE_VILLAGERS, HandlerUtil.getDimKey((class_1297)player), player);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, deny -> {
                        MessageSender.sendFlagMsg(deny);
                        ci.cancel();
                    });
                }
                if (target instanceof class_3989) {
                    checkEvent = new FlagCheckEvent(target.method_24515(), RegionFlag.MELEE_WANDERING_TRADER, HandlerUtil.getDimKey((class_1297)player), player);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, deny -> {
                        MessageSender.sendFlagMsg(deny);
                        ci.cancel();
                    });
                }
                Set<String> entityTags = FlagConfig.getCoveredBlockEntityTags();
                boolean isCoveredByTag = entityTags.stream().anyMatch(entityTag -> {
                    class_2960 tagRl = class_2960.method_60654((String)entityTag);
                    return target.method_5752().contains(tagRl.method_12832());
                });
                Set<String> entities = FlagConfig.getCoveredBlockEntities();
                boolean isBlockEntityCovered = entities.stream().anyMatch(entity -> {
                    class_2960 entityRl = class_2960.method_60654((String)entity);
                    class_2960 targetRl = class_1299.method_5890((class_1299)target.method_5864());
                    return targetRl != null && targetRl.equals((Object)entityRl);
                });
                if (isBlockEntityCovered || isCoveredByTag) {
                    FlagCheckEvent checkEvent2 = new FlagCheckEvent(target.method_24515(), RegionFlag.BREAK_BLOCKS, HandlerUtil.getDimKey((class_1297)player), player);
                    if (Services.EVENT.post(checkEvent2)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent2, null, onDeny -> {
                        ci.cancel();
                        MessageSender.sendFlagMsg(onDeny);
                    });
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, allow=1)
    private void onUseElytraTick(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        if (HandlerUtil.isServerSide((class_1297)player) && player.method_6128()) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.NO_FLIGHT, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                player.method_66281();
            });
        }
    }
}

